/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.starter.cloud.feign.impl;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.starter.cloud.feign.IJeecgFeignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
@Import(value={FeignClientsConfiguration.class})
public class JeecgFeignService
implements IJeecgFeignService {
    private static final Logger log = LoggerFactory.getLogger(JeecgFeignService.class);
    Feign.Builder builder;

    public JeecgFeignService(Decoder decoder, Encoder encoder, Client client, Contract contract) {
        this.builder = Feign.builder().client(client).encoder(encoder).decoder(decoder).contract(contract);
        this.builder.requestInterceptor(requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (null != attributes) {
                HttpServletRequest request = attributes.getRequest();
                log.info("Feign request: {}", (Object)request.getRequestURI());
                String token = request.getHeader("X-Access-Token");
                if (token == null) {
                    token = request.getParameter("token");
                }
                log.info("Feign request token: {}", (Object)token);
                requestTemplate.header("X-Access-Token", new String[]{token});
            }
        });
    }

    @Override
    public <T> T newInstance(Class<T> clientClass, String serviceName) {
        return (T)this.builder.target(clientClass, String.format("http://%s/", serviceName));
    }
}

