/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.Closeable;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.SqlStatements;

public class StatementContext
implements Closeable {
    private final ConfigRegistry config;
    private final ExtensionMethod extensionMethod;
    private final Set<Cleanable> cleanables = new LinkedHashSet<Cleanable>();
    private String rawSql;
    private String renderedSql;
    private String parsedSql;
    private PreparedStatement statement;
    private Connection connection;
    private Binding binding = new Binding();
    private boolean returningGeneratedKeys = false;
    private String[] generatedKeysColumnNames = new String[0];
    private boolean concurrentUpdatable = false;

    StatementContext() {
        this(new ConfigRegistry());
    }

    StatementContext(ConfigRegistry config) {
        this(config, null);
    }

    StatementContext(ConfigRegistry config, ExtensionMethod extensionMethod) {
        this.config = Objects.requireNonNull(config);
        this.extensionMethod = extensionMethod;
    }

    public <C extends JdbiConfig<C>> C getConfig(Class<C> configClass) {
        return this.config.get(configClass);
    }

    public ConfigRegistry getConfig() {
        return this.config;
    }

    public Map<String, Object> getAttributes() {
        return this.getConfig(SqlStatements.class).getAttributes();
    }

    public Object getAttribute(String key) {
        return this.getConfig(SqlStatements.class).getAttribute(key);
    }

    public void define(String key, Object value) {
        this.getConfig(SqlStatements.class).define(key, value);
    }

    public Optional<Argument> findArgumentFor(Type type, Object value) {
        return this.getConfig(Arguments.class).findFor(type, value);
    }

    public SqlArrayArgumentStrategy getSqlArrayArgumentStrategy() {
        return this.getConfig(SqlArrayTypes.class).getArgumentStrategy();
    }

    public Optional<SqlArrayType<?>> findSqlArrayTypeFor(Type elementType) {
        return this.getConfig(SqlArrayTypes.class).findFor(elementType);
    }

    public <T> Optional<ColumnMapper<T>> findColumnMapperFor(Class<T> type) {
        return this.getConfig(ColumnMappers.class).findFor(type);
    }

    public <T> Optional<ColumnMapper<T>> findColumnMapperFor(GenericType<T> type) {
        return this.getConfig(ColumnMappers.class).findFor(type);
    }

    public Optional<ColumnMapper<?>> findColumnMapperFor(Type type) {
        return this.getConfig(ColumnMappers.class).findFor(type);
    }

    public Optional<RowMapper<?>> findRowMapperFor(Type type) {
        return this.getConfig(RowMappers.class).findFor(type);
    }

    public <T> Optional<RowMapper<T>> findRowMapperFor(Class<T> type) {
        return this.getConfig(RowMappers.class).findFor(type);
    }

    public <T> Optional<RowMapper<T>> findRowMapperFor(GenericType<T> type) {
        return this.getConfig(RowMappers.class).findFor(type);
    }

    public Optional<Collector<?, ?, ?>> findCollectorFor(Type containerType) {
        return this.getConfig(JdbiCollectors.class).findFor(containerType);
    }

    public Optional<Type> findElementTypeFor(Type containerType) {
        return this.getConfig(JdbiCollectors.class).findElementTypeFor(containerType);
    }

    StatementContext setRawSql(String rawSql) {
        this.rawSql = rawSql;
        return this;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    void setRenderedSql(String renderedSql) {
        this.renderedSql = renderedSql;
    }

    public String getRenderedSql() {
        return this.renderedSql;
    }

    void setParsedSql(String parsedSql) {
        this.parsedSql = parsedSql;
    }

    public String getParsedSql() {
        return this.parsedSql;
    }

    void setStatement(PreparedStatement stmt) {
        this.statement = stmt;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    StatementContext setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    StatementContext setBinding(Binding b) {
        this.binding = b;
        return this;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setReturningGeneratedKeys(boolean b) {
        if (this.isConcurrentUpdatable() && b) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.returningGeneratedKeys = b;
    }

    public boolean isReturningGeneratedKeys() {
        return this.returningGeneratedKeys || this.generatedKeysColumnNames.length > 0;
    }

    public String[] getGeneratedKeysColumnNames() {
        return Arrays.copyOf(this.generatedKeysColumnNames, this.generatedKeysColumnNames.length);
    }

    public void setGeneratedKeysColumnNames(String[] generatedKeysColumnNames) {
        this.generatedKeysColumnNames = Arrays.copyOf(generatedKeysColumnNames, generatedKeysColumnNames.length);
    }

    public boolean isConcurrentUpdatable() {
        return this.concurrentUpdatable;
    }

    public void setConcurrentUpdatable(boolean concurrentUpdatable) {
        if (concurrentUpdatable && this.isReturningGeneratedKeys()) {
            throw new IllegalArgumentException("Cannot create a result set that is concurrent updatable and is returning generated keys.");
        }
        this.concurrentUpdatable = concurrentUpdatable;
    }

    public void addCleanable(Cleanable cleanable) {
        this.cleanables.add(cleanable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SQLException exception = null;
        try {
            ArrayList<Cleanable> cleanables = new ArrayList<Cleanable>(this.cleanables);
            this.cleanables.clear();
            Collections.reverse(cleanables);
            for (Cleanable cleanable : cleanables) {
                try {
                    cleanable.close();
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
        }
        finally {
            if (exception != null) {
                throw new CloseException("Exception thrown while cleaning StatementContext", exception);
            }
        }
    }

    public ExtensionMethod getExtensionMethod() {
        return this.extensionMethod;
    }
}

