/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.StatementBuilderFactory;
import org.jdbi.v3.core.statement.StatementContext;

public class DefaultStatementBuilder
implements StatementBuilder {
    public static final StatementBuilderFactory FACTORY = c -> new DefaultStatementBuilder();

    @Override
    public Statement create(Connection conn, StatementContext ctx) throws SQLException {
        return conn.createStatement();
    }

    @Override
    public PreparedStatement create(Connection conn, String sql, StatementContext ctx) throws SQLException {
        if (ctx.isReturningGeneratedKeys()) {
            String[] columnNames = ctx.getGeneratedKeysColumnNames();
            if (columnNames != null && columnNames.length > 0) {
                return conn.prepareStatement(sql, columnNames);
            }
            return conn.prepareStatement(sql, 1);
        }
        if (ctx.isConcurrentUpdatable()) {
            return conn.prepareStatement(sql, 1003, 1008);
        }
        return conn.prepareStatement(sql);
    }

    @Override
    public void close(Connection conn, String sql, Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    @Override
    public void close(Connection conn) {
    }

    @Override
    public CallableStatement createCall(Connection conn, String sql, StatementContext ctx) throws SQLException {
        return conn.prepareCall(sql);
    }
}

