/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

abstract class BaseStatement<This>
implements Closeable,
Configurable<This> {
    final This typedThis = this;
    private final Handle handle;
    private final StatementContext ctx;
    private final Collection<StatementCustomizer> customizers = new ArrayList<StatementCustomizer>();

    BaseStatement(Handle handle) {
        if (GenericTypes.findGenericParameter(this.getClass(), BaseStatement.class).map(GenericTypes::getErasedType).map(type -> !type.isAssignableFrom(this.getClass())).orElse(false).booleanValue()) {
            throw new IllegalStateException("inconsistent SqlStatement hierarchy");
        }
        this.handle = handle;
        this.ctx = new StatementContext(handle.getConfig().createCopy(), handle.getExtensionMethod());
    }

    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.ctx.getConfig();
    }

    public final StatementContext getContext() {
        return this.ctx;
    }

    This addCleanable(Cleanable cleanable) {
        this.getContext().addCleanable(cleanable);
        return this.typedThis;
    }

    void addCustomizers(Collection<StatementCustomizer> customizers) {
        this.customizers.addAll(customizers);
    }

    public final This addCustomizer(StatementCustomizer customizer) {
        this.customizers.add(customizer);
        return this.typedThis;
    }

    final void beforeExecution(PreparedStatement stmt) {
        for (StatementCustomizer customizer : this.customizers) {
            try {
                customizer.beforeExecution(stmt, this.ctx);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.ctx);
            }
        }
    }

    final void afterExecution(PreparedStatement stmt) {
        for (StatementCustomizer customizer : this.customizers) {
            try {
                customizer.afterExecution(stmt, this.ctx);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception thrown in statement customization", e, this.ctx);
            }
        }
    }

    @Override
    public void close() {
        this.getContext().close();
    }
}

