/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.jdbi.v3.core.result.NoResultsException;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

public class ResultProducers {
    private ResultProducers() {
    }

    public static ResultProducer<Integer> returningUpdateCount() {
        return (statementSupplier, ctx) -> {
            try {
                Integer n = ((PreparedStatement)statementSupplier.get()).getUpdateCount();
                return n;
            }
            finally {
                ctx.close();
            }
        };
    }

    public static ResultProducer<ResultBearing> returningResults() {
        return (supplier, ctx) -> ResultBearing.of(ResultProducers.getResultSet(supplier, ctx), ctx);
    }

    private static Supplier<ResultSet> getResultSet(Supplier<PreparedStatement> supplier, StatementContext ctx) {
        return () -> {
            try {
                ResultSet rs = ((PreparedStatement)supplier.get()).getResultSet();
                if (rs == null) {
                    throw new NoResultsException("Statement returned no results", ctx);
                }
                ctx.addCleanable(rs::close);
                return rs;
            }
            catch (SQLException e) {
                throw new ResultSetException("Could not get result set", e, ctx);
            }
        };
    }

    public static ResultProducer<ResultBearing> returningGeneratedKeys(String ... generatedKeyColumnNames) {
        return (supplier, ctx) -> {
            ctx.setReturningGeneratedKeys(true);
            if (generatedKeyColumnNames.length > 0) {
                ctx.setGeneratedKeysColumnNames(generatedKeyColumnNames);
            }
            return ResultBearing.of(ResultProducers.getGeneratedKeys(supplier, ctx), ctx);
        };
    }

    private static Supplier<ResultSet> getGeneratedKeys(Supplier<PreparedStatement> supplier, StatementContext ctx) {
        return () -> {
            try {
                ResultSet rs = ((PreparedStatement)supplier.get()).getGeneratedKeys();
                if (rs == null) {
                    throw new NoResultsException("Statement returned no generated keys", ctx);
                }
                ctx.addCleanable(rs::close);
                return rs;
            }
            catch (SQLException e) {
                throw new ResultSetException("Could not get generated keys", e, ctx);
            }
        };
    }
}

