/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class FieldMapper<T>
implements RowMapper<T> {
    static final String DEFAULT_PREFIX = "";
    private final Class<T> type;
    private final String prefix;
    private final ConcurrentMap<String, Optional<Field>> fieldByNameCache = new ConcurrentHashMap<String, Optional<Field>>();

    public static RowMapperFactory factory(Class<?> type) {
        return RowMapperFactory.of(type, FieldMapper.of(type));
    }

    public static RowMapperFactory factory(Class<?> type, String prefix) {
        return RowMapperFactory.of(type, FieldMapper.of(type, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return FieldMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new FieldMapper<T>(type, prefix);
    }

    private FieldMapper(Class<T> type, String prefix) {
        this.type = type;
        this.prefix = prefix;
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>();
        ArrayList<ColumnMapper<Object>> mappers = new ArrayList<ColumnMapper<Object>>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ResultSetMetaData metadata = rs.getMetaData();
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            Optional maybeField;
            String name = metadata.getColumnLabel(i).toLowerCase();
            if (this.prefix.length() > 0) {
                if (name.length() <= this.prefix.length() || !name.regionMatches(true, 0, this.prefix, 0, this.prefix.length())) continue;
                name = name.substring(this.prefix.length());
            }
            if (!(maybeField = this.fieldByNameCache.computeIfAbsent(name, n -> this.fieldByColumn((String)n, columnNameMatchers))).isPresent()) continue;
            Field field = (Field)maybeField.get();
            Type type = field.getGenericType();
            ColumnMapper<Object> mapper = ctx.findColumnMapperFor(type).orElse((r, n, c) -> r.getObject(n));
            columnNumbers.add(i);
            mappers.add(mapper);
            fields.add(field);
        }
        if (columnNumbers.isEmpty() && metadata.getColumnCount() > 0) {
            throw new IllegalArgumentException(String.format("Mapping fields for type %s didn't find any matching columns in result set", this.type));
        }
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && columnNumbers.size() != metadata.getColumnCount()) {
            throw new IllegalArgumentException(String.format("Mapping fields for type %s only matched properties for %s of %s columns", this.type, columnNumbers.size(), metadata.getColumnCount()));
        }
        return (r, c) -> {
            T obj;
            try {
                obj = this.type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("A type, %s, was mapped which was not instantiable", this.type.getName()), e);
            }
            for (int i = 0; i < columnNumbers.size(); ++i) {
                int columnNumber = (Integer)columnNumbers.get(i);
                ColumnMapper mapper = (ColumnMapper)mappers.get(i);
                Field field = (Field)fields.get(i);
                Object value = mapper.map(rs, columnNumber, ctx);
                try {
                    field.setAccessible(true);
                    field.set(obj, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(String.format("Unable to access property, %s", field.getName()), e);
                }
            }
            return obj;
        };
    }

    private Optional<Field> fieldByColumn(String columnName, List<ColumnNameMatcher> columnNameMatchers) {
        for (Class<T> aClass = this.type; aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                String paramName = this.paramName(field);
                for (ColumnNameMatcher strategy : columnNameMatchers) {
                    if (!strategy.columnNameMatches(columnName, paramName)) continue;
                    return Optional.of(field);
                }
            }
        }
        return Optional.empty();
    }

    private String paramName(Field field) {
        return Optional.ofNullable(field.getAnnotation(ColumnName.class)).map(ColumnName::value).orElseGet(field::getName);
    }
}

