/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructors;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class ConstructorMapper<T>
implements RowMapper<T> {
    static final String DEFAULT_PREFIX = "";
    private final Constructor<T> constructor;
    private final String prefix;
    private final ConstructorProperties constructorProperties;

    public static RowMapperFactory factory(Class<?> clazz) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz));
    }

    public static RowMapperFactory factory(Class<?> clazz, String prefix) {
        return RowMapperFactory.of(clazz, ConstructorMapper.of(clazz, prefix));
    }

    public static RowMapperFactory factory(Constructor<?> constructor) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor));
    }

    public static RowMapperFactory factory(Constructor<?> constructor, String prefix) {
        return RowMapperFactory.of(constructor.getDeclaringClass(), ConstructorMapper.of(constructor, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type));
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return ConstructorMapper.of(JdbiConstructors.findConstructorFor(type), prefix);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor) {
        return ConstructorMapper.of(constructor, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Constructor<T> constructor, String prefix) {
        return new ConstructorMapper<T>(constructor, prefix);
    }

    private ConstructorMapper(Constructor<T> constructor, String prefix) {
        this.constructor = constructor;
        this.prefix = prefix;
        this.constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        ArrayList<String> columnNames = new ArrayList<String>(metadata.getColumnCount());
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            columnNames.add(metadata.getColumnLabel(i));
        }
        int columns = this.constructor.getParameterCount();
        if (columns > columnNames.size()) {
            throw new IllegalStateException(columnNames.size() + " columns in result set, but constructor takes " + this.constructor.getParameterCount());
        }
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        int[] columnMap = new int[columns];
        ColumnMapper[] mappers = new ColumnMapper[columns];
        for (int i = 0; i < columns; ++i) {
            Type type = this.constructor.getGenericParameterTypes()[i];
            String paramName = ConstructorMapper.paramName(this.constructor.getParameters(), i, this.constructorProperties);
            int columnIndex = this.columnIndexForParameter(columnNames, paramName, columnNameMatchers);
            mappers[i] = ctx.findColumnMapperFor(type).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find column mapper for type '%s' of parameter '%s' for constructor '%s'", type, paramName, this.constructor)));
            columnMap[i] = columnIndex;
        }
        return (r, c) -> {
            Object[] params = new Object[columns];
            for (int i = 0; i < columns; ++i) {
                params[i] = mappers[i].map(r, columnMap[i] + 1, c);
            }
            try {
                return this.constructor.newInstance(params);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e);
            }
        };
    }

    private int columnIndexForParameter(List<String> columnNames, String parameterName, List<ColumnNameMatcher> columnNameMatchers) {
        int result = -1;
        block0: for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            if (this.prefix.length() > 0) {
                if (columnName.length() <= this.prefix.length() || !columnName.regionMatches(true, 0, this.prefix, 0, this.prefix.length())) continue;
                columnName = columnName.substring(this.prefix.length());
            }
            for (ColumnNameMatcher strategy : columnNameMatchers) {
                if (!strategy.columnNameMatches(columnName, parameterName)) continue;
                if (result >= 0) {
                    throw new IllegalArgumentException(String.format("Constructor '%s' parameter '%s' matches multiple columns: '%s' (%d) and '%s' (%d)", this.constructor, parameterName, columnNames.get(result), result, columnNames.get(i), i));
                }
                result = i;
                continue block0;
            }
        }
        if (result >= 0) {
            return result;
        }
        throw new IllegalArgumentException("Constructor '" + this.constructor + "' parameter '" + parameterName + "' has no column in the result set.  Verify that the Java compiler is configured to emit parameter names, that your result set has the columns expected, or annotate the parameter names explicitly with @ColumnName");
    }

    private static String paramName(Parameter[] parameters, int position, ConstructorProperties parameterNames) {
        Parameter parameter = parameters[position];
        ColumnName dbName = parameter.getAnnotation(ColumnName.class);
        if (dbName != null) {
            return dbName.value();
        }
        if (parameterNames != null) {
            return parameterNames.value()[position];
        }
        return parameter.getName();
    }
}

