/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.ColumnNameMatcher;
import org.jdbi.v3.core.mapper.reflect.ReflectionMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class BeanMapper<T>
implements RowMapper<T> {
    static final String DEFAULT_PREFIX = "";
    private final Class<T> type;
    private final String prefix;
    private final BeanInfo info;
    private final ConcurrentMap<String, Optional<PropertyDescriptor>> descriptorByColumnCache = new ConcurrentHashMap<String, Optional<PropertyDescriptor>>();

    public static RowMapperFactory factory(Class<?> type) {
        return RowMapperFactory.of(type, BeanMapper.of(type));
    }

    public static RowMapperFactory factory(Class<?> type, String prefix) {
        return RowMapperFactory.of(type, BeanMapper.of(type, prefix));
    }

    public static <T> RowMapper<T> of(Class<T> type) {
        return BeanMapper.of(type, DEFAULT_PREFIX);
    }

    public static <T> RowMapper<T> of(Class<T> type, String prefix) {
        return new BeanMapper<T>(type, prefix);
    }

    private BeanMapper(Class<T> type, String prefix) {
        this.type = type;
        this.prefix = prefix;
        try {
            this.info = Introspector.getBeanInfo(type);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T map(ResultSet rs, StatementContext ctx) throws SQLException {
        return this.specialize(rs, ctx).map(rs, ctx);
    }

    @Override
    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>();
        ArrayList<ColumnMapper<Object>> mappers = new ArrayList<ColumnMapper<Object>>();
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        ResultSetMetaData metadata = rs.getMetaData();
        List<ColumnNameMatcher> columnNameMatchers = ctx.getConfig(ReflectionMappers.class).getColumnNameMatchers();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            Optional maybeDescriptor;
            String name = metadata.getColumnLabel(i);
            if (this.prefix.length() > 0) {
                if (name.length() <= this.prefix.length() || !name.regionMatches(true, 0, this.prefix, 0, this.prefix.length())) continue;
                name = name.substring(this.prefix.length());
            }
            if (!(maybeDescriptor = this.descriptorByColumnCache.computeIfAbsent(name, n -> this.descriptorForColumn((String)n, columnNameMatchers))).isPresent()) continue;
            PropertyDescriptor descriptor = (PropertyDescriptor)maybeDescriptor.get();
            Type type = descriptor.getReadMethod().getGenericReturnType();
            ColumnMapper<Object> mapper = ctx.findColumnMapperFor(type).orElse((r, n, c) -> r.getObject(n));
            columnNumbers.add(i);
            mappers.add(mapper);
            properties.add(descriptor);
        }
        if (columnNumbers.isEmpty() && metadata.getColumnCount() > 0) {
            throw new IllegalArgumentException(String.format("Mapping bean type %s didn't find any matching columns in result set", this.type));
        }
        if (ctx.getConfig(ReflectionMappers.class).isStrictMatching() && columnNumbers.size() != metadata.getColumnCount()) {
            throw new IllegalArgumentException(String.format("Mapping bean type %s only matched properties for %s of %s columns", this.type, columnNumbers.size(), metadata.getColumnCount()));
        }
        return (r, c) -> {
            T bean;
            try {
                bean = this.type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
            }
            for (int i = 0; i < columnNumbers.size(); ++i) {
                int columnNumber = (Integer)columnNumbers.get(i);
                ColumnMapper mapper = (ColumnMapper)mappers.get(i);
                PropertyDescriptor property = (PropertyDescriptor)properties.get(i);
                Object value = mapper.map(r, columnNumber, ctx);
                try {
                    property.getWriteMethod().invoke(bean, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", property.getName()), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", property.getName()), e);
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException(String.format("No appropriate method to write property %s", property.getName()), e);
                }
            }
            return bean;
        };
    }

    private Optional<PropertyDescriptor> descriptorForColumn(String columnName, List<ColumnNameMatcher> columnNameMatchers) {
        for (PropertyDescriptor descriptor : this.info.getPropertyDescriptors()) {
            String paramName = this.paramName(descriptor);
            for (ColumnNameMatcher strategy : columnNameMatchers) {
                if (!strategy.columnNameMatches(columnName, paramName)) continue;
                return Optional.of(descriptor);
            }
        }
        return Optional.empty();
    }

    private String paramName(PropertyDescriptor descriptor) {
        return Stream.of(descriptor.getReadMethod(), descriptor.getWriteMethod()).filter(Objects::nonNull).map(method -> method.getAnnotation(ColumnName.class)).filter(Objects::nonNull).map(ColumnName::value).findFirst().orElseGet(descriptor::getName);
    }
}

