/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.collector;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.OptionalBuilder;
import org.jdbi.v3.core.generic.GenericTypes;

public class BuiltInCollectorFactory
implements CollectorFactory {
    private final Map<Class<?>, Collector<?, ?, ?>> collectors = new HashMap();

    public BuiltInCollectorFactory() {
        this.collectors.put(Optional.class, BuiltInCollectorFactory.toOptional());
        this.collectors.put(Collection.class, Collectors.toCollection(ArrayList::new));
        this.collectors.put(List.class, Collectors.toList());
        this.collectors.put(ArrayList.class, Collectors.toCollection(ArrayList::new));
        this.collectors.put(LinkedList.class, Collectors.toCollection(LinkedList::new));
        this.collectors.put(Set.class, Collectors.toSet());
        this.collectors.put(HashSet.class, Collectors.toCollection(HashSet::new));
        this.collectors.put(SortedSet.class, Collectors.toCollection(TreeSet::new));
        this.collectors.put(TreeSet.class, Collectors.toCollection(TreeSet::new));
        this.collectors.put(Map.class, BuiltInCollectorFactory.toMap(LinkedHashMap::new));
        this.collectors.put(HashMap.class, BuiltInCollectorFactory.toMap(HashMap::new));
        this.collectors.put(LinkedHashMap.class, BuiltInCollectorFactory.toMap(LinkedHashMap::new));
        this.collectors.put(SortedMap.class, BuiltInCollectorFactory.toMap(TreeMap::new));
        this.collectors.put(TreeMap.class, BuiltInCollectorFactory.toMap(TreeMap::new));
        this.collectors.put(ConcurrentMap.class, BuiltInCollectorFactory.toMap(ConcurrentHashMap::new));
        this.collectors.put(ConcurrentHashMap.class, BuiltInCollectorFactory.toMap(ConcurrentHashMap::new));
        this.collectors.put(WeakHashMap.class, BuiltInCollectorFactory.toMap(WeakHashMap::new));
    }

    @Override
    public boolean accepts(Type containerType) {
        Class<?> erasedType = GenericTypes.getErasedType(containerType);
        return this.collectors.containsKey(erasedType) && containerType instanceof ParameterizedType;
    }

    @Override
    public Optional<Type> elementType(Type containerType) {
        Class<?> erasedType = GenericTypes.getErasedType(containerType);
        if (Map.class.isAssignableFrom(erasedType)) {
            return Optional.of(GenericTypes.resolveMapEntryType(containerType));
        }
        return GenericTypes.findGenericParameter(containerType, erasedType);
    }

    @Override
    public Collector<?, ?, ?> build(Type containerType) {
        Class<?> erasedType = GenericTypes.getErasedType(containerType);
        return this.collectors.get(erasedType);
    }

    public static <T> Collector<T, ?, Optional<T>> toOptional() {
        return Collector.of(OptionalBuilder::new, OptionalBuilder::set, (left, right) -> left.build().isPresent() ? left : right, OptionalBuilder::build, new Collector.Characteristics[0]);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<M> mapFactory) {
        return Collector.of(mapFactory, BuiltInCollectorFactory::putEntry, BuiltInCollectorFactory::combine, new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M map, Map.Entry<K, V> entry) {
        BuiltInCollectorFactory.putEntry(map, entry.getKey(), entry.getValue());
    }

    private static <K, V, M extends Map<K, V>> void putEntry(M map, K key, V value) {
        V oldValue = map.put(key, value);
        if (oldValue != null) {
            throw new IllegalStateException(String.format("Multiple values for Map key '%s': ['%s','%s',...]", key, oldValue, value));
        }
    }

    private static <K, V, M extends Map<K, V>> M combine(M a, M b) {
        b.forEach((k, v) -> BuiltInCollectorFactory.putEntry(a, k, v));
        return a;
    }
}

