/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.function.Supplier;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

class CollectionColumnMapper<T, C extends Collection<T>>
implements ColumnMapper<C> {
    private final ColumnMapper<T> elementMapper;
    private final Supplier<C> collectionSupplier;

    CollectionColumnMapper(ColumnMapper<T> elementMapper, Supplier<C> collectionSupplier) {
        this.elementMapper = elementMapper;
        this.collectionSupplier = collectionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Array array = r.getArray(columnNumber);
        if (array == null) {
            return null;
        }
        try {
            C c = this.buildFromResultSet(array, ctx);
            return c;
        }
        finally {
            array.free();
        }
    }

    private C buildFromResultSet(Array array, StatementContext ctx) throws SQLException {
        Collection result = (Collection)this.collectionSupplier.get();
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                result.add(this.elementMapper.map(rs, 2, ctx));
            }
        }
        return (C)result;
    }
}

