/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

public class BeanPropertyArguments
implements NamedArgumentFinder {
    private final String prefix;
    private final Object bean;
    private BeanInfo info;

    public BeanPropertyArguments(String prefix, Object bean) {
        this.prefix = prefix == null || prefix.isEmpty() ? "" : prefix + ".";
        this.bean = bean;
        try {
            this.info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new UnableToCreateStatementException("Failed to introspect object which is supposed to be used to set named args for a statement via JavaBean properties", e);
        }
    }

    @Override
    public Optional<Argument> find(String name, StatementContext ctx) {
        if (name.startsWith(this.prefix)) {
            String propertyName = name.substring(this.prefix.length());
            for (PropertyDescriptor descriptor : this.info.getPropertyDescriptors()) {
                if (!propertyName.equals(descriptor.getName())) continue;
                Method getter = descriptor.getReadMethod();
                if (getter == null) {
                    throw new UnableToCreateStatementException(String.format("No getter method found for bean property [%s] on [%s]", propertyName, this.bean), ctx);
                }
                try {
                    Type propertyType = getter.getGenericReturnType();
                    Object propertyValue = getter.invoke(this.bean, new Object[0]);
                    Optional<Argument> argument = ctx.findArgumentFor(propertyType, propertyValue);
                    if (!argument.isPresent()) {
                        throw new UnableToCreateStatementException(String.format("No argument factory registered for type [%s] for bean property [%s] on [%s]", propertyType, propertyName, this.bean), ctx);
                    }
                    return argument;
                }
                catch (IllegalAccessException e) {
                    throw new UnableToCreateStatementException(String.format("Access exception invoking getter for bean property [%s] on [%s]", propertyName, this.bean), e, ctx);
                }
                catch (InvocationTargetException e) {
                    throw new UnableToCreateStatementException(String.format("Invocation target exception invoking getter for bean property [%s] on [%s]", propertyName, this.bean), e, ctx);
                }
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return "{lazy bean property arguments \"" + this.bean + "\"";
    }
}

