// $ANTLR 3.4 org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g 2017-07-18 01:35:07

    package org.jdbi.v3.core.internal.lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class ColonStatementLexer extends Lexer {
    public static final int EOF=-1;
    public static final int COLON=4;
    public static final int COMMENT=5;
    public static final int DOUBLE_COLON=6;
    public static final int DOUBLE_QUOTE=7;
    public static final int DOUBLE_QUOTED_TEXT=8;
    public static final int ESCAPE=9;
    public static final int ESCAPED_TEXT=10;
    public static final int ESCAPE_QUOTE=11;
    public static final int LITERAL=12;
    public static final int NAME=13;
    public static final int NAMED_PARAM=14;
    public static final int POSITIONAL_PARAM=15;
    public static final int QUOTE=16;
    public static final int QUOTED_TEXT=17;

      @Override
      public void reportError(RecognitionException e) {
        throw new IllegalArgumentException(e);
      }


    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public ColonStatementLexer() {} 
    public ColonStatementLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public ColonStatementLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g"; }

    // $ANTLR start "QUOTE"
    public final void mQUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:14:15: ( '\\'' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:14:17: '\\''
            {
            match('\''); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTE"

    // $ANTLR start "ESCAPE"
    public final void mESCAPE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:15:16: ( '\\\\' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:15:18: '\\\\'
            {
            match('\\'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE"

    // $ANTLR start "ESCAPE_QUOTE"
    public final void mESCAPE_QUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:16:22: ( ESCAPE QUOTE )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:16:24: ESCAPE QUOTE
            {
            mESCAPE(); 


            mQUOTE(); 


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE_QUOTE"

    // $ANTLR start "DOUBLE_QUOTE"
    public final void mDOUBLE_QUOTE() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:17:22: ( '\"' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:17:24: '\"'
            {
            match('\"'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_QUOTE"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:18:15: ({...}? => ':' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:18:17: {...}? => ':'
            {
            if ( !((input.LA(2) != ':')) ) {
                throw new FailedPredicateException(input, "COLON", "input.LA(2) != ':'");
            }

            match(':'); 

            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "DOUBLE_COLON"
    public final void mDOUBLE_COLON() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:19:22: ({...}? => '::' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:19:24: {...}? => '::'
            {
            if ( !((input.LA(2) == ':')) ) {
                throw new FailedPredicateException(input, "DOUBLE_COLON", "input.LA(2) == ':'");
            }

            match("::"); 



            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_COLON"

    // $ANTLR start "NAME"
    public final void mNAME() throws RecognitionException {
        try {
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:20:14: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '_' | '.' | '#' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:
            {
            if ( input.LA(1)=='#'||input.LA(1)=='.'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAME"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:22:8: ( '/*' ( . )* '*/' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:22:10: '/*' ( . )* '*/'
            {
            match("/*"); 



            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:22:15: ( . )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0=='*') ) {
                    int LA1_1 = input.LA(2);

                    if ( (LA1_1=='/') ) {
                        alt1=2;
                    }
                    else if ( ((LA1_1 >= '\u0000' && LA1_1 <= '.')||(LA1_1 >= '0' && LA1_1 <= '\uFFFF')) ) {
                        alt1=1;
                    }


                }
                else if ( ((LA1_0 >= '\u0000' && LA1_0 <= ')')||(LA1_0 >= '+' && LA1_0 <= '\uFFFF')) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:22:15: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            match("*/"); 



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "QUOTED_TEXT"
    public final void mQUOTED_TEXT() throws RecognitionException {
        try {
            int _type = QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:23:12: ( QUOTE ( ESCAPE_QUOTE |~ QUOTE )* QUOTE )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:23:14: QUOTE ( ESCAPE_QUOTE |~ QUOTE )* QUOTE
            {
            mQUOTE(); 


            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:23:20: ( ESCAPE_QUOTE |~ QUOTE )*
            loop2:
            do {
                int alt2=3;
                int LA2_0 = input.LA(1);

                if ( (LA2_0=='\\') ) {
                    int LA2_2 = input.LA(2);

                    if ( (LA2_2=='\'') ) {
                        int LA2_4 = input.LA(3);

                        if ( ((LA2_4 >= '\u0000' && LA2_4 <= '\uFFFF')) ) {
                            alt2=1;
                        }

                        else {
                            alt2=2;
                        }


                    }
                    else if ( ((LA2_2 >= '\u0000' && LA2_2 <= '&')||(LA2_2 >= '(' && LA2_2 <= '\uFFFF')) ) {
                        alt2=2;
                    }


                }
                else if ( ((LA2_0 >= '\u0000' && LA2_0 <= '&')||(LA2_0 >= '(' && LA2_0 <= '[')||(LA2_0 >= ']' && LA2_0 <= '\uFFFF')) ) {
                    alt2=2;
                }


                switch (alt2) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:23:21: ESCAPE_QUOTE
            	    {
            	    mESCAPE_QUOTE(); 


            	    }
            	    break;
            	case 2 :
            	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:23:36: ~ QUOTE
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\u000F')||(input.LA(1) >= '\u0011' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            mQUOTE(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTED_TEXT"

    // $ANTLR start "DOUBLE_QUOTED_TEXT"
    public final void mDOUBLE_QUOTED_TEXT() throws RecognitionException {
        try {
            int _type = DOUBLE_QUOTED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:24:19: ( DOUBLE_QUOTE (~ DOUBLE_QUOTE )+ DOUBLE_QUOTE )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:24:21: DOUBLE_QUOTE (~ DOUBLE_QUOTE )+ DOUBLE_QUOTE
            {
            mDOUBLE_QUOTE(); 


            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:24:34: (~ DOUBLE_QUOTE )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( ((LA3_0 >= '\u0000' && LA3_0 <= '!')||(LA3_0 >= '#' && LA3_0 <= '\uFFFF')) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            mDOUBLE_QUOTE(); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_QUOTED_TEXT"

    // $ANTLR start "ESCAPED_TEXT"
    public final void mESCAPED_TEXT() throws RecognitionException {
        try {
            int _type = ESCAPED_TEXT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:25:14: ( ESCAPE . )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:25:16: ESCAPE .
            {
            mESCAPE(); 


            matchAny(); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPED_TEXT"

    // $ANTLR start "NAMED_PARAM"
    public final void mNAMED_PARAM() throws RecognitionException {
        try {
            int _type = NAMED_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:27:12: ( COLON ( NAME )+ )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:27:14: COLON ( NAME )+
            {
            mCOLON(); 


            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:27:20: ( NAME )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case '#':
                case '.':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:
            	    {
            	    if ( input.LA(1)=='#'||input.LA(1)=='.'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NAMED_PARAM"

    // $ANTLR start "POSITIONAL_PARAM"
    public final void mPOSITIONAL_PARAM() throws RecognitionException {
        try {
            int _type = POSITIONAL_PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:28:17: ( '?' )
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:28:19: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "POSITIONAL_PARAM"

    // $ANTLR start "LITERAL"
    public final void mLITERAL() throws RecognitionException {
        try {
            int _type = LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:8: ( ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | DOUBLE_COLON | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '<' | '>' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | COLON '=' )+ | '*' | '/' )
            int alt6=3;
            int LA6_0 = input.LA(1);

            if ( ((LA6_0 >= '\t' && LA6_0 <= '\n')||LA6_0=='\r'||(LA6_0 >= ' ' && LA6_0 <= '!')||LA6_0=='#'||LA6_0==','||LA6_0=='.'||(LA6_0 >= '0' && LA6_0 <= '9')||LA6_0=='='||(LA6_0 >= '@' && LA6_0 <= 'Z')||LA6_0=='_'||(LA6_0 >= 'a' && LA6_0 <= 'z')) ) {
                alt6=1;
            }
            else if ( (LA6_0==':') && (((input.LA(2) != ':')||(input.LA(2) == ':')))) {
                alt6=1;
            }
            else if ( ((LA6_0 >= '$' && LA6_0 <= '&')||(LA6_0 >= '(' && LA6_0 <= ')')||LA6_0=='+'||LA6_0=='-'||(LA6_0 >= ';' && LA6_0 <= '<')||LA6_0=='>'||LA6_0=='['||(LA6_0 >= ']' && LA6_0 <= '^')||LA6_0=='`'||(LA6_0 >= '{' && LA6_0 <= '~')) ) {
                alt6=1;
            }
            else if ( (LA6_0=='*') ) {
                alt6=2;
            }
            else if ( (LA6_0=='/') ) {
                alt6=3;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }
            switch (alt6) {
                case 1 :
                    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:10: ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | DOUBLE_COLON | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '<' | '>' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | COLON '=' )+
                    {
                    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:10: ( NAME | ' ' | '\\t' | '\\n' | '\\r' | ',' | '@' | '!' | '=' | DOUBLE_COLON | ';' | '(' | ')' | '[' | ']' | '+' | '-' | '<' | '>' | '%' | '&' | '^' | '|' | '$' | '~' | '{' | '}' | '`' | COLON '=' )+
                    int cnt5=0;
                    loop5:
                    do {
                        int alt5=30;
                        int LA5_0 = input.LA(1);

                        if ( (LA5_0=='#'||LA5_0=='.'||(LA5_0 >= '0' && LA5_0 <= '9')||(LA5_0 >= 'A' && LA5_0 <= 'Z')||LA5_0=='_'||(LA5_0 >= 'a' && LA5_0 <= 'z')) ) {
                            alt5=1;
                        }
                        else if ( (LA5_0==' ') ) {
                            alt5=2;
                        }
                        else if ( (LA5_0=='\t') ) {
                            alt5=3;
                        }
                        else if ( (LA5_0=='\n') ) {
                            alt5=4;
                        }
                        else if ( (LA5_0=='\r') ) {
                            alt5=5;
                        }
                        else if ( (LA5_0==',') ) {
                            alt5=6;
                        }
                        else if ( (LA5_0=='@') ) {
                            alt5=7;
                        }
                        else if ( (LA5_0=='!') ) {
                            alt5=8;
                        }
                        else if ( (LA5_0=='=') ) {
                            alt5=9;
                        }
                        else if ( (LA5_0==':') && (((input.LA(2) != ':')||(input.LA(2) == ':')))) {
                            int LA5_11 = input.LA(2);

                            if ( (LA5_11==':') && ((input.LA(2) == ':'))) {
                                alt5=10;
                            }
                            else if ( (LA5_11=='=') && ((input.LA(2) != ':'))) {
                                alt5=29;
                            }


                        }
                        else if ( (LA5_0==';') ) {
                            alt5=11;
                        }
                        else if ( (LA5_0=='(') ) {
                            alt5=12;
                        }
                        else if ( (LA5_0==')') ) {
                            alt5=13;
                        }
                        else if ( (LA5_0=='[') ) {
                            alt5=14;
                        }
                        else if ( (LA5_0==']') ) {
                            alt5=15;
                        }
                        else if ( (LA5_0=='+') ) {
                            alt5=16;
                        }
                        else if ( (LA5_0=='-') ) {
                            alt5=17;
                        }
                        else if ( (LA5_0=='<') ) {
                            alt5=18;
                        }
                        else if ( (LA5_0=='>') ) {
                            alt5=19;
                        }
                        else if ( (LA5_0=='%') ) {
                            alt5=20;
                        }
                        else if ( (LA5_0=='&') ) {
                            alt5=21;
                        }
                        else if ( (LA5_0=='^') ) {
                            alt5=22;
                        }
                        else if ( (LA5_0=='|') ) {
                            alt5=23;
                        }
                        else if ( (LA5_0=='$') ) {
                            alt5=24;
                        }
                        else if ( (LA5_0=='~') ) {
                            alt5=25;
                        }
                        else if ( (LA5_0=='{') ) {
                            alt5=26;
                        }
                        else if ( (LA5_0=='}') ) {
                            alt5=27;
                        }
                        else if ( (LA5_0=='`') ) {
                            alt5=28;
                        }


                        switch (alt5) {
                    	case 1 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:11: NAME
                    	    {
                    	    mNAME(); 


                    	    }
                    	    break;
                    	case 2 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:18: ' '
                    	    {
                    	    match(' '); 

                    	    }
                    	    break;
                    	case 3 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:24: '\\t'
                    	    {
                    	    match('\t'); 

                    	    }
                    	    break;
                    	case 4 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:31: '\\n'
                    	    {
                    	    match('\n'); 

                    	    }
                    	    break;
                    	case 5 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:38: '\\r'
                    	    {
                    	    match('\r'); 

                    	    }
                    	    break;
                    	case 6 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:45: ','
                    	    {
                    	    match(','); 

                    	    }
                    	    break;
                    	case 7 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:51: '@'
                    	    {
                    	    match('@'); 

                    	    }
                    	    break;
                    	case 8 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:57: '!'
                    	    {
                    	    match('!'); 

                    	    }
                    	    break;
                    	case 9 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:63: '='
                    	    {
                    	    match('='); 

                    	    }
                    	    break;
                    	case 10 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:69: DOUBLE_COLON
                    	    {
                    	    mDOUBLE_COLON(); 


                    	    }
                    	    break;
                    	case 11 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:84: ';'
                    	    {
                    	    match(';'); 

                    	    }
                    	    break;
                    	case 12 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:90: '('
                    	    {
                    	    match('('); 

                    	    }
                    	    break;
                    	case 13 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:96: ')'
                    	    {
                    	    match(')'); 

                    	    }
                    	    break;
                    	case 14 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:102: '['
                    	    {
                    	    match('['); 

                    	    }
                    	    break;
                    	case 15 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:30:108: ']'
                    	    {
                    	    match(']'); 

                    	    }
                    	    break;
                    	case 16 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:12: '+'
                    	    {
                    	    match('+'); 

                    	    }
                    	    break;
                    	case 17 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:18: '-'
                    	    {
                    	    match('-'); 

                    	    }
                    	    break;
                    	case 18 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:24: '<'
                    	    {
                    	    match('<'); 

                    	    }
                    	    break;
                    	case 19 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:30: '>'
                    	    {
                    	    match('>'); 

                    	    }
                    	    break;
                    	case 20 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:36: '%'
                    	    {
                    	    match('%'); 

                    	    }
                    	    break;
                    	case 21 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:42: '&'
                    	    {
                    	    match('&'); 

                    	    }
                    	    break;
                    	case 22 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:48: '^'
                    	    {
                    	    match('^'); 

                    	    }
                    	    break;
                    	case 23 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:54: '|'
                    	    {
                    	    match('|'); 

                    	    }
                    	    break;
                    	case 24 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:60: '$'
                    	    {
                    	    match('$'); 

                    	    }
                    	    break;
                    	case 25 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:66: '~'
                    	    {
                    	    match('~'); 

                    	    }
                    	    break;
                    	case 26 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:72: '{'
                    	    {
                    	    match('{'); 

                    	    }
                    	    break;
                    	case 27 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:78: '}'
                    	    {
                    	    match('}'); 

                    	    }
                    	    break;
                    	case 28 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:84: '`'
                    	    {
                    	    match('`'); 

                    	    }
                    	    break;
                    	case 29 :
                    	    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:90: COLON '='
                    	    {
                    	    mCOLON(); 


                    	    match('='); 

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt5 >= 1 ) break loop5;
                                EarlyExitException eee =
                                    new EarlyExitException(5, input);
                                throw eee;
                        }
                        cnt5++;
                    } while (true);


                    }
                    break;
                case 2 :
                    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:104: '*'
                    {
                    match('*'); 

                    }
                    break;
                case 3 :
                    // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:31:110: '/'
                    {
                    match('/'); 

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LITERAL"

    public void mTokens() throws RecognitionException {
        // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:8: ( COMMENT | QUOTED_TEXT | DOUBLE_QUOTED_TEXT | ESCAPED_TEXT | NAMED_PARAM | POSITIONAL_PARAM | LITERAL )
        int alt7=7;
        int LA7_0 = input.LA(1);

        if ( (LA7_0=='/') ) {
            switch ( input.LA(2) ) {
            case '*':
                {
                alt7=1;
                }
                break;
            default:
                alt7=7;
            }

        }
        else if ( (LA7_0=='\'') ) {
            alt7=2;
        }
        else if ( (LA7_0=='\"') ) {
            alt7=3;
        }
        else if ( (LA7_0=='\\') ) {
            alt7=4;
        }
        else if ( (LA7_0==':') && (((input.LA(2) != ':')||(input.LA(2) == ':')))) {
            int LA7_5 = input.LA(2);

            if ( (LA7_5==':') && ((input.LA(2) == ':'))) {
                alt7=7;
            }
            else if ( (LA7_5=='#'||LA7_5=='.'||(LA7_5 >= '0' && LA7_5 <= '9')||(LA7_5 >= 'A' && LA7_5 <= 'Z')||LA7_5=='_'||(LA7_5 >= 'a' && LA7_5 <= 'z')) && ((input.LA(2) != ':'))) {
                alt7=5;
            }
            else if ( (LA7_5=='=') && ((input.LA(2) != ':'))) {
                alt7=7;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 5, input);

                throw nvae;

            }
        }
        else if ( (LA7_0=='?') ) {
            alt7=6;
        }
        else if ( ((LA7_0 >= '\t' && LA7_0 <= '\n')||LA7_0=='\r'||(LA7_0 >= ' ' && LA7_0 <= '!')||(LA7_0 >= '#' && LA7_0 <= '&')||(LA7_0 >= '(' && LA7_0 <= '.')||(LA7_0 >= '0' && LA7_0 <= '9')||(LA7_0 >= ';' && LA7_0 <= '>')||(LA7_0 >= '@' && LA7_0 <= '[')||(LA7_0 >= ']' && LA7_0 <= '~')) ) {
            alt7=7;
        }
        else {
            NoViableAltException nvae =
                new NoViableAltException("", 7, 0, input);

            throw nvae;

        }
        switch (alt7) {
            case 1 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:10: COMMENT
                {
                mCOMMENT(); 


                }
                break;
            case 2 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:18: QUOTED_TEXT
                {
                mQUOTED_TEXT(); 


                }
                break;
            case 3 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:30: DOUBLE_QUOTED_TEXT
                {
                mDOUBLE_QUOTED_TEXT(); 


                }
                break;
            case 4 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:49: ESCAPED_TEXT
                {
                mESCAPED_TEXT(); 


                }
                break;
            case 5 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:62: NAMED_PARAM
                {
                mNAMED_PARAM(); 


                }
                break;
            case 6 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:74: POSITIONAL_PARAM
                {
                mPOSITIONAL_PARAM(); 


                }
                break;
            case 7 :
                // org/jdbi/v3/core/internal/lexer/ColonStatementLexer.g:1:91: LITERAL
                {
                mLITERAL(); 


                }
                break;

        }

    }


 

}