/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Migration {
    final List<String> schemas = new ArrayList<String>();
    final List<String> paths = new ArrayList<String>();
    boolean cleanAfter = true;

    public Migration withDefaultPath() {
        this.paths.add("db/migration");
        return this;
    }

    public Migration withPath(String migrationPath) {
        this.paths.add(migrationPath);
        return this;
    }

    public Migration withPaths(String ... migrationPaths) {
        this.paths.addAll(Arrays.asList(migrationPaths));
        return this;
    }

    public Migration withSchema(String schema) {
        this.schemas.add(schema);
        return this;
    }

    public Migration withSchemas(String ... moreSchemas) {
        this.schemas.addAll(Arrays.asList(moreSchemas));
        return this;
    }

    public Migration cleanAfter() {
        this.cleanAfter = true;
        return this;
    }

    public Migration cleanAfter(boolean cleanAfter) {
        this.cleanAfter = cleanAfter;
        return this;
    }

    public static Migration before() {
        return new Migration();
    }
}

