/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.jdbi.v3.testing.junit5.JdbiExtension;

public class JdbiH2Extension
extends JdbiExtension {
    private final String url;
    private String user = null;
    private String password = null;

    static JdbiExtension instance() {
        return new JdbiH2Extension();
    }

    static JdbiExtension instance(String options) {
        return new JdbiH2Extension(options);
    }

    public JdbiH2Extension() {
        this("");
    }

    public JdbiH2Extension(String options) {
        StringBuilder url = new StringBuilder("jdbc:h2:mem:").append(UUID.randomUUID());
        if (!options.isEmpty()) {
            if (!options.startsWith(";")) {
                url.append(';');
            }
            url.append(options);
        }
        this.url = url.toString();
    }

    public JdbiH2Extension withUser(String user) {
        this.user = user;
        return this;
    }

    public JdbiH2Extension withCredentials(String user, String password) {
        this.user = user;
        this.password = password;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected DataSource createDataSource() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.getUrl());
        if (this.user != null) {
            ds.setUser(this.user);
            if (this.password != null) {
                ds.setPassword(this.password);
            }
        }
        return ds;
    }
}

