/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5.tc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.jdbi.v3.meta.Beta;
import org.testcontainers.containers.JdbcDatabaseContainer;

@Beta
public final class TestcontainersDatabaseInformation {
    private static final TestcontainersDatabaseInformation CLICKHOUSE = TestcontainersDatabaseInformation.of(null, null, null, (catalogName, schemaName) -> String.format("CREATE DATABASE %s Engine = Memory", schemaName));
    private static final TestcontainersDatabaseInformation MYSQL = TestcontainersDatabaseInformation.of("root", null, null, (catalogName, schemaName) -> String.format("CREATE DATABASE %s", catalogName));
    private static final TestcontainersDatabaseInformation ORACLE_XE = TestcontainersDatabaseInformation.ofScript("system", null, null, (catalogName, schemaName) -> {
        ArrayList<String> script = new ArrayList<String>();
        script.add(String.format("CREATE USER %s IDENTIFIED BY %s QUOTA UNLIMITED ON USERS", schemaName, schemaName));
        script.add(String.format("GRANT CREATE session TO %s", schemaName));
        script.add(String.format("GRANT CREATE table TO %s", schemaName));
        script.add(String.format("GRANT CREATE view TO %s", schemaName));
        script.add(String.format("GRANT CREATE any trigger TO %s", schemaName));
        script.add(String.format("GRANT CREATE any procedure TO %s", schemaName));
        script.add(String.format("GRANT CREATE sequence TO %s", schemaName));
        script.add(String.format("GRANT CREATE synonym TO %s", schemaName));
        return script;
    });
    private static final TestcontainersDatabaseInformation POSTGRES = TestcontainersDatabaseInformation.of(null, "test", null, (catalogName, schemaName) -> String.format("CREATE SCHEMA %s", schemaName));
    private static final TestcontainersDatabaseInformation TRINO = TestcontainersDatabaseInformation.of(null, "memory", null, (catalogName, schemaName) -> String.format("CREATE SCHEMA %s", schemaName));
    private static final TestcontainersDatabaseInformation MSSQL = TestcontainersDatabaseInformation.of("sa", null, null, (catalogName, schemaName) -> String.format("CREATE DATABASE %s", catalogName));
    private static final Map<String, TestcontainersDatabaseInformation> KNOWN_CONTAINERS;
    private final String user;
    private final String catalog;
    private final String schema;
    private final BiFunction<String, String, List<String>> createStatement;

    public static TestcontainersDatabaseInformation forTestcontainerClass(Class<? extends JdbcDatabaseContainer> containerClazz) {
        return KNOWN_CONTAINERS.get(containerClazz.getName());
    }

    public static TestcontainersDatabaseInformation of(String user, String catalog, String schema, BiFunction<String, String, String> createStatement) {
        return new TestcontainersDatabaseInformation(user, catalog, schema, TestcontainersDatabaseInformation.wrapperFor(createStatement));
    }

    public static TestcontainersDatabaseInformation ofScript(String user, String catalog, String schema, BiFunction<String, String, List<String>> createStatement) {
        return new TestcontainersDatabaseInformation(user, catalog, schema, createStatement);
    }

    private TestcontainersDatabaseInformation(String user, String catalog, String schema, BiFunction<String, String, List<String>> createStatement) {
        this.user = user;
        this.catalog = catalog;
        this.schema = schema;
        this.createStatement = createStatement;
    }

    Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    Optional<String> getCatalog() {
        return Optional.ofNullable(this.catalog);
    }

    Optional<String> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    TestcontainersDatabaseInformation forCatalogAndSchema(String catalog, String schema) {
        return new TestcontainersDatabaseInformation(this.user, catalog, schema, this.createStatement);
    }

    List<String> getCreationScript() {
        return this.createStatement.apply(this.getCatalog().orElseThrow(() -> new IllegalArgumentException("no catalog name present!")), this.getSchema().orElseThrow(() -> new IllegalArgumentException("no schema name present!")));
    }

    public String toString() {
        return new StringJoiner(".", "", "").add(this.getCatalog().orElse("*")).add(this.getSchema().orElse("*")).toString();
    }

    private static BiFunction<String, String, List<String>> wrapperFor(BiFunction<String, String, String> createFunction) {
        return (catalogName, schemaName) -> Collections.singletonList((String)createFunction.apply((String)catalogName, (String)schemaName));
    }

    static {
        HashMap<String, TestcontainersDatabaseInformation> knownContainers = new HashMap<String, TestcontainersDatabaseInformation>();
        knownContainers.put("org.testcontainers.containers.MySQLContainer", MYSQL);
        knownContainers.put("org.testcontainers.containers.MariaDBContainer", MYSQL);
        knownContainers.put("org.testcontainers.tidb.TiDBContainer", MYSQL);
        knownContainers.put("org.testcontainers.containers.PostgreSQLContainer", POSTGRES);
        knownContainers.put("org.testcontainers.containers.CockroachContainer", POSTGRES);
        knownContainers.put("org.testcontainers.containers.YugabyteDBYSQLContainer", POSTGRES);
        knownContainers.put("org.testcontainers.containers.ClickHouseContainer", CLICKHOUSE);
        knownContainers.put("org.testcontainers.containers.OracleContainer", ORACLE_XE);
        knownContainers.put("org.testcontainers.containers.TrinoContainer", TRINO);
        knownContainers.put("org.testcontainers.containers.MSSQLServerContainer", MSSQL);
        KNOWN_CONTAINERS = knownContainers;
    }
}

