/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.AttachedExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.RowReducer;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.statement.ParameterCustomizerFactory;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.SqlBatchHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlCallHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;
import org.jdbi.v3.sqlobject.statement.internal.SqlQueryHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlUpdateHandler;

abstract class CustomizingStatementHandler<StatementType extends SqlStatement<StatementType>>
implements ExtensionHandler {
    private final List<BoundCustomizer> statementCustomizers;
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> sqlObjectType, Method method) {
        this.sqlObjectType = sqlObjectType;
        this.method = method;
        this.statementCustomizers = new ArrayList<BoundCustomizer>();
        Stream.concat(JdbiClassUtils.superTypes(sqlObjectType), Stream.of(sqlObjectType)).flatMap(xva$0 -> CustomizingStatementHandler.annotationsFor(xva$0)).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForType((Annotation)a, sqlObjectType)).map(BoundCustomizer::of).forEach(this.statementCustomizers::add);
        CustomizingStatementHandler.annotationsFor(method).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForMethod((Annotation)a, sqlObjectType, method)).map(BoundCustomizer::of).forEach(this.statementCustomizers::add);
        this.parameterCustomizers().forEach(this.statementCustomizers::add);
    }

    private static Stream<Annotation> annotationsFor(AnnotatedElement ... elements) {
        return Stream.of(elements).map(AnnotatedElement::getAnnotations).flatMap(Stream::of).filter(a -> a.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class));
    }

    private Stream<BoundCustomizer> parameterCustomizers() {
        Parameter[] parameters = this.method.getParameters();
        return IntStream.range(0, parameters.length).boxed().flatMap(i -> this.eachParameterCustomizers(parameters[i], (Integer)i));
    }

    private Stream<BoundCustomizer> eachParameterCustomizers(Parameter parameter, Integer i) {
        Type parameterType = this.getParameterType(parameter);
        List<BoundCustomizer> customizers = CustomizingStatementHandler.annotationsFor(parameter).map(a -> CustomizingStatementHandler.instantiateFactory(a).createForParameter((Annotation)a, this.sqlObjectType, this.method, parameter, i, parameterType)).map(c -> new BoundCustomizer(){
            final /* synthetic */ SqlStatementParameterCustomizer val$c;
            final /* synthetic */ Integer val$i;
            final /* synthetic */ CustomizingStatementHandler this$0;
            {
                this.val$c = sqlStatementParameterCustomizer;
                this.val$i = n;
                this.this$0 = this$0;
            }

            @Override
            public void warm(ConfigRegistry config) {
                this.val$c.warm(config);
            }

            @Override
            public void apply(SqlStatement<?> stmt, Object[] args) throws SQLException {
                this.val$c.apply(stmt, args[this.val$i]);
            }
        }).toList();
        if (!customizers.isEmpty()) {
            return customizers.stream();
        }
        if (parameter.getType() == Consumer.class) {
            if (this.method.getReturnType() != Void.TYPE) {
                throw new IllegalStateException("SQL Object methods with a Consumer parameter must have void return type.");
            }
            return Stream.empty();
        }
        if (parameter.getType() == Function.class && (this instanceof SqlCallHandler || this instanceof SqlBatchHandler || this instanceof SqlQueryHandler || this instanceof SqlUpdateHandler)) {
            return Stream.empty();
        }
        return Stream.of(this.defaultParameterCustomizer(parameter, i));
    }

    private BoundCustomizer defaultParameterCustomizer(final Parameter parameter, final Integer i) {
        final Type parameterType = this.getParameterType(parameter);
        return new BoundCustomizer(){
            final /* synthetic */ CustomizingStatementHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void warm(ConfigRegistry config) {
                this.create(config).warm(config);
            }

            @Override
            public void apply(SqlStatement<?> stmt, Object[] args) throws SQLException {
                this.create(stmt.getConfig()).apply(stmt, args[i]);
            }

            private SqlStatementParameterCustomizer create(ConfigRegistry config) {
                return CustomizingStatementHandler.getDefaultParameterCustomizerFactory(config).createForParameter(this.this$0.sqlObjectType, this.this$0.method, parameter, i, parameterType);
            }
        };
    }

    Type getParameterType(Parameter parameter) {
        return GenericTypes.resolveType((Type)parameter.getParameterizedType(), this.sqlObjectType);
    }

    private static ParameterCustomizerFactory getDefaultParameterCustomizerFactory(ConfigRegistry config) {
        return ((SqlObjects)config.get(SqlObjects.class)).getDefaultParameterCustomizerFactory();
    }

    private static SqlStatementCustomizerFactory instantiateFactory(Annotation annotation) {
        SqlStatementCustomizingAnnotation sqlStatementCustomizingAnnotation = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
        return (SqlStatementCustomizerFactory)JdbiClassUtils.checkedCreateInstance(sqlStatementCustomizingAnnotation.value());
    }

    public AttachedExtensionHandler attachTo(ConfigRegistry config, Object target) {
        final Supplier<String> locatedSql = this.locateSql(config);
        return new AttachedExtensionHandler(){
            final /* synthetic */ CustomizingStatementHandler this$0;
            {
                this.this$0 = this$0;
            }

            public Object invoke(HandleSupplier handleSupplier, Object ... args) throws Exception {
                Handle h = handleSupplier.getHandle();
                Object stmt = this.this$0.createStatement(h, (String)locatedSql.get());
                stmt.attachToHandleForCleanup();
                SqlObjectStatementConfiguration cfg = (SqlObjectStatementConfiguration)stmt.getConfig(SqlObjectStatementConfiguration.class);
                cfg.setArgs(args);
                this.this$0.configureReturner(stmt, cfg);
                this.this$0.applyCustomizers(stmt, JdbiClassUtils.safeVarargs((Object[])args));
                return cfg.getReturner().get();
            }

            public void warm(ConfigRegistry config) {
                this.this$0.statementCustomizers.forEach(s -> s.warm(config));
                this.this$0.warm(config);
            }
        };
    }

    protected void warm(ConfigRegistry config) {
    }

    void applyCustomizers(StatementType stmt, Object[] args) {
        this.statementCustomizers.forEach(b -> {
            try {
                b.apply((SqlStatement<?>)stmt, args);
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException((Exception)e, stmt.getContext());
            }
        });
    }

    abstract void configureReturner(StatementType var1, SqlObjectStatementConfiguration var2);

    abstract StatementType createStatement(Handle var1, String var2);

    Supplier<String> locateSql(ConfigRegistry config) {
        try {
            String sql = ((SqlObjects)config.get(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.method, config);
            return () -> sql;
        }
        catch (RuntimeException e) {
            return () -> {
                throw e;
            };
        }
    }

    Method getMethod() {
        return this.method;
    }

    static RowMapper<?> rowMapperFor(UseRowMapper useRowMapper) {
        return (RowMapper)JdbiClassUtils.checkedCreateInstance(useRowMapper.value());
    }

    static RowReducer<?, ?> rowReducerFor(UseRowReducer useRowReducer) {
        return (RowReducer)JdbiClassUtils.checkedCreateInstance(useRowReducer.value());
    }

    private static interface BoundCustomizer {
        public void apply(SqlStatement<?> var1, Object[] var2) throws SQLException;

        public void warm(ConfigRegistry var1);

        public static BoundCustomizer of(final SqlStatementCustomizer inner) {
            return new BoundCustomizer(){

                @Override
                public void apply(SqlStatement<?> stmt, Object[] args) throws SQLException {
                    inner.apply(stmt);
                }

                @Override
                public void warm(ConfigRegistry config) {
                    inner.warm(config);
                }
            };
        }
    }
}

