/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction.internal;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.transaction.Transaction;

public class TransactionDecorator
implements ExtensionHandlerCustomizer {
    public ExtensionHandler customize(ExtensionHandler delegate, Class<?> sqlObjectType, Method method) {
        Transaction txnAnnotation = Stream.of(method, sqlObjectType).map(ae -> ae.getAnnotation(Transaction.class)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new TransactionException("No @Transaction annotation found"));
        TransactionIsolationLevel isolation = txnAnnotation.value();
        boolean readOnly = txnAnnotation.readOnly();
        return (handleSupplier, target, args) -> {
            Object object;
            block5: {
                boolean flipReadOnly;
                Handle handle = handleSupplier.getHandle();
                if (handle.isInTransaction() && handle.isReadOnly() && !readOnly) {
                    throw new TransactionException("Tried to execute a nested @Transaction(readOnly=false) inside a readOnly transaction");
                }
                HandleCallback callback = transactionHandle -> delegate.invoke(handleSupplier, target, args);
                boolean bl = flipReadOnly = readOnly != handle.isReadOnly();
                if (flipReadOnly) {
                    handle.setReadOnly(readOnly);
                }
                try {
                    object = handle.inTransaction(isolation, callback);
                    if (!flipReadOnly) break block5;
                    handle.setReadOnly(!readOnly);
                }
                catch (Throwable throwable) {
                    if (flipReadOnly) {
                        handle.setReadOnly(!readOnly);
                    }
                    throw throwable;
                }
            }
            return object;
        };
    }
}

