/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

abstract class ResultReturner {
    ResultReturner() {
    }

    static ResultReturner forOptionalReturn(Class<?> extensionType, Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return new VoidReturner();
        }
        return ResultReturner.forMethod(extensionType, method);
    }

    static ResultReturner forMethod(Class<?> extensionType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), extensionType);
        QualifiedType qualifiedReturnType = QualifiedType.of((Type)returnType).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method}));
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        if (Void.TYPE.equals(returnClass)) {
            return ResultReturner.findConsumerArgument(method).orElseThrow(() -> new IllegalStateException(String.format("Method %s#%s is annotated as if it should return a value, but the method is void.", method.getDeclaringClass().getName(), method.getName())));
        }
        if (ResultIterable.class.equals((Object)returnClass)) {
            return new ResultIterableReturner(qualifiedReturnType);
        }
        if (Stream.class.equals((Object)returnClass)) {
            return new StreamReturner(qualifiedReturnType);
        }
        if (ResultIterator.class.equals((Object)returnClass)) {
            return new ResultIteratorReturner(qualifiedReturnType);
        }
        if (Iterator.class.equals((Object)returnClass)) {
            return new IteratorReturner(qualifiedReturnType);
        }
        if (method.isAnnotationPresent(SingleValue.class)) {
            return new SingleValueReturner(qualifiedReturnType);
        }
        return ResultReturner.findFunctionArgument(returnType, method).orElseGet(() -> new CollectedResultReturner(qualifiedReturnType));
    }

    static Optional<ResultReturner> findConsumerArgument(Method method) {
        Optional<ResultReturner> result = Optional.empty();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int consumerIndex = 0; consumerIndex < paramTypes.length; ++consumerIndex) {
            if (paramTypes[consumerIndex] != Consumer.class) continue;
            if (result.isPresent()) {
                throw new IllegalArgumentException(String.format("Method %s has multiple consumer arguments!", method));
            }
            result = Optional.of(ConsumerResultReturner.of(method, consumerIndex));
        }
        return result;
    }

    static Optional<ResultReturner> findFunctionArgument(Type returnType, Method method) {
        Optional<ResultReturner> result = Optional.empty();
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int functionIndex = 0; functionIndex < paramTypes.length; ++functionIndex) {
            if (paramTypes[functionIndex] != Function.class) continue;
            if (result.isPresent()) {
                throw new IllegalArgumentException(String.format("Method %s has multiple function arguments!", method));
            }
            result = FunctionResultReturner.of(returnType, method, functionIndex);
        }
        return result;
    }

    protected abstract Object mappedResult(ResultIterable<?> var1, StatementContext var2);

    protected abstract Object reducedResult(Stream<?> var1, StatementContext var2);

    protected abstract QualifiedType<?> elementType(ConfigRegistry var1);

    protected void warm(ConfigRegistry config) {
        Optional.ofNullable(this.elementType(config)).ifPresent(arg_0 -> ((Mappers)((Mappers)config.get(Mappers.class))).findFor(arg_0));
    }

    private static Object checkResult(Object result, QualifiedType<?> type) {
        if (result == null && GenericTypes.getErasedType((Type)type.getType()).isPrimitive()) {
            throw new IllegalStateException("SQL method returns primitive " + String.valueOf(type) + ", but statement returned no results");
        }
        return result;
    }

    static class VoidReturner
    extends ResultReturner {
        VoidReturner() {
        }

        @Override
        protected Void mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            iterable.stream().forEach(i -> {});
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return void from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return null;
        }
    }

    static class ResultIterableReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIterableReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, ResultIterable.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterable<T> element type T in method return type " + String.valueOf(returnType)));
        }

        protected ResultIterable<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable;
        }

        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return ResultIterable from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class StreamReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        StreamReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Stream.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Stream<T> element type T in method return type " + String.valueOf(returnType)));
        }

        @Override
        protected Stream<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.stream();
        }

        @Override
        protected Stream<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            return stream;
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class ResultIteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        ResultIteratorReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect ResultIterator<T> element type T in method return type " + String.valueOf(returnType)));
        }

        protected ResultIterator<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.iterator();
        }

        protected ResultIterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            throw new UnsupportedOperationException("Cannot return ResultIterator from a @UseRowReducer method");
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class IteratorReturner
    extends ResultReturner {
        private final QualifiedType<?> elementType;

        IteratorReturner(QualifiedType<?> returnType) {
            this.elementType = (QualifiedType)returnType.flatMapType(type -> GenericTypes.findGenericParameter((Type)type, Iterator.class)).orElseThrow(() -> new IllegalStateException("Cannot reflect Iterator<T> element type T in method return type " + String.valueOf(returnType)));
        }

        @Override
        protected Iterator<?> mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return iterable.iterator();
        }

        @Override
        protected Iterator<?> reducedResult(Stream<?> stream, StatementContext ctx) {
            return stream.iterator();
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }
    }

    static class SingleValueReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        SingleValueReturner(QualifiedType<T> returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext ctx) {
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        protected QualifiedType<T> elementType(ConfigRegistry config) {
            return this.returnType;
        }
    }

    static final class ConsumerResultReturner<T>
    extends ResultReturner {
        private final int consumerIndex;
        private final QualifiedType<?> elementType;
        private final BiConsumer<Stream<T>, Consumer<Object>> consumer;

        ConsumerResultReturner(int consumerIndex, QualifiedType<?> elementType, BiConsumer<Stream<T>, Consumer<Object>> consumer) {
            this.consumerIndex = consumerIndex;
            this.elementType = elementType;
            this.consumer = consumer;
        }

        @Override
        protected Void mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            try (Stream stream = iterable.stream();){
                this.consumer.accept(stream, this.findConsumer(ctx));
            }
            return null;
        }

        @Override
        protected Void reducedResult(Stream<?> stream, StatementContext ctx) {
            try (Stream<?> reducedStream = stream;){
                this.consumer.accept(reducedStream, this.findConsumer(ctx));
            }
            return null;
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }

        private Consumer<Object> findConsumer(StatementContext ctx) {
            return (Consumer)((SqlObjectStatementConfiguration)ctx.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[this.consumerIndex];
        }

        static ResultReturner of(Method method, int consumerIndex) {
            Type parameterType = method.getGenericParameterTypes()[consumerIndex];
            QualifiedType elementType = QualifiedType.of((Type)((Type)GenericTypes.findGenericParameter((Type)parameterType, Consumer.class).orElseThrow(() -> new IllegalStateException(String.format("Cannot reflect Consumer<T> element type T in method consumer parameter '%s'", parameterType))))).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method.getParameters()[consumerIndex]}));
            Type type = elementType.getType();
            if (GenericTypes.isSuperType(Iterator.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Iterator.class) {
                    return ConsumerResultReturner.getIteratorConsumer(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterator.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Iterator type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Consumer argument for %s can not use subtype '%s' of Iterator!", method, type));
            }
            if (GenericTypes.isSuperType(Stream.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Stream.class) {
                    return ConsumerResultReturner.getStreamConsumer(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Stream.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Stream type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Consumer argument for %s can not use subtype '%s' of Stream!", method, type));
            }
            if (GenericTypes.isSuperType(Iterable.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Iterable.class) {
                    return ConsumerResultReturner.getIterableConsumer(consumerIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterable.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Iterable type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Consumer argument for %s can not use subtype '%s' of Iterable!", method, type));
            }
            return ConsumerResultReturner.getEachConsumer(consumerIndex, elementType);
        }

        private static ResultReturner getIteratorConsumer(int consumerIndex, QualifiedType<?> iteratorType) {
            return new ConsumerResultReturner(consumerIndex, iteratorType, (s, f) -> f.accept(s.iterator()));
        }

        private static ResultReturner getStreamConsumer(int consumerIndex, QualifiedType<?> streamType) {
            return new ConsumerResultReturner(consumerIndex, streamType, (s, f) -> f.accept(s));
        }

        private static ResultReturner getIterableConsumer(int consumerIndex, QualifiedType<?> iterableType) {
            return new ConsumerResultReturner(consumerIndex, iterableType, (s, f) -> f.accept(s::iterator));
        }

        private static ResultReturner getEachConsumer(int consumerIndex, QualifiedType<?> iterableType) {
            return new ConsumerResultReturner(consumerIndex, iterableType, Stream::forEach);
        }
    }

    static final class FunctionResultReturner<T, R>
    extends ResultReturner {
        private final int functionIndex;
        private final QualifiedType<?> elementType;
        private final BiFunction<Stream<T>, Function<Object, R>, R> function;

        FunctionResultReturner(int functionIndex, QualifiedType<?> elementType, BiFunction<Stream<T>, Function<Object, R>, R> function) {
            this.functionIndex = functionIndex;
            this.elementType = elementType;
            this.function = function;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            try (Stream stream = iterable.stream();){
                R r = this.function.apply(stream, this.findFunction(ctx));
                return r;
            }
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext ctx) {
            try (Stream<?> reducedStream = stream;){
                R r = this.function.apply(reducedStream, this.findFunction(ctx));
                return r;
            }
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.elementType;
        }

        private Function<Object, R> findFunction(StatementContext ctx) {
            return (Function)((SqlObjectStatementConfiguration)ctx.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[this.functionIndex];
        }

        static Optional<ResultReturner> of(Type returnType, Method method, int functionIndex) {
            Type parameterType = method.getGenericParameterTypes()[functionIndex];
            QualifiedType targetType = QualifiedType.of((Type)((Type)GenericTypes.findGenericParameter((Type)parameterType, Function.class, (int)1).orElseThrow(() -> new IllegalStateException(String.format("Cannot reflect Function<T, R> element type R in method function parameter '%s'", parameterType)))));
            if (!QualifiedType.of((Type)returnType).equals((Object)targetType)) {
                throw new IllegalArgumentException(String.format("Function<T, R> argument R ('%s') for %s must match the function return type ('%s')", targetType, method, returnType));
            }
            QualifiedType elementType = QualifiedType.of((Type)((Type)GenericTypes.findGenericParameter((Type)parameterType, Function.class, (int)0).orElseThrow(() -> new IllegalStateException(String.format("Cannot reflect Function<T, R> element type T in method function parameter '%s'", parameterType))))).withAnnotations((Iterable)new Qualifiers().findFor(new AnnotatedElement[]{method.getParameters()[functionIndex]}));
            Type type = elementType.getType();
            if (GenericTypes.isSuperType(Iterator.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Iterator.class) {
                    return FunctionResultReturner.getIteratorFunction(functionIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterator.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Iterator type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Function argument for %s can not use subtype '%s' of Iterator!", method, type));
            }
            if (GenericTypes.isSuperType(Stream.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Stream.class) {
                    return FunctionResultReturner.getStreamFunction(functionIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Stream.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Stream type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Function argument for %s can not use subtype '%s' of Stream!", method, type));
            }
            if (GenericTypes.isSuperType(Iterable.class, (Type)type)) {
                if (GenericTypes.getErasedType((Type)type) == Iterable.class) {
                    return FunctionResultReturner.getIterableFunction(functionIndex, elementType.mapType(t -> (Type)GenericTypes.findGenericParameter((Type)t, Iterable.class).orElseThrow(() -> new IllegalStateException(String.format("Couldn't find Iterable type on '%s'", elementType)))));
                }
                throw new IllegalArgumentException(String.format("Function argument for %s can not use subtype '%s' of Iterable!", method, type));
            }
            return Optional.empty();
        }

        private static Optional<ResultReturner> getIteratorFunction(int functionIndex, QualifiedType<?> iteratorType) {
            return Optional.of(new FunctionResultReturner(functionIndex, iteratorType, (s, f) -> f.apply(s.iterator())));
        }

        private static Optional<ResultReturner> getStreamFunction(int functionIndex, QualifiedType<?> streamType) {
            return Optional.of(new FunctionResultReturner(functionIndex, streamType, (s, f) -> f.apply(s)));
        }

        private static Optional<ResultReturner> getIterableFunction(int functionIndex, QualifiedType<?> iterableType) {
            return Optional.of(new FunctionResultReturner(functionIndex, iterableType, (s, f) -> f.apply(s::iterator)));
        }
    }

    static class CollectedResultReturner<T>
    extends ResultReturner {
        private final QualifiedType<T> returnType;

        CollectedResultReturner(QualifiedType<T> returnType) {
            this.returnType = returnType;
        }

        @Override
        protected Object mappedResult(ResultIterable<?> iterable, StatementContext ctx) {
            Collector collector = ctx.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return iterable.collect(collector);
            }
            return ResultReturner.checkResult(iterable.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected Object reducedResult(Stream<?> stream, StatementContext ctx) {
            Collector collector = ctx.findCollectorFor(this.returnType.getType()).orElse(null);
            if (collector != null) {
                return stream.collect(collector);
            }
            return ResultReturner.checkResult(stream.findFirst().orElse(null), this.returnType);
        }

        @Override
        protected void warm(ConfigRegistry config) {
            super.warm(config);
            ((JdbiCollectors)config.get(JdbiCollectors.class)).findFor(this.returnType.getType());
        }

        @Override
        protected QualifiedType<?> elementType(ConfigRegistry config) {
            return this.returnType.flatMapType(type -> ((JdbiCollectors)config.get(JdbiCollectors.class)).findElementTypeFor(type)).orElse(this.returnType);
        }
    }
}

