/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;

public class RegisterConstructorMapperImpl
extends SimpleExtensionConfigurer {
    private final RowMapperFactory constructorMapper;

    public RegisterConstructorMapperImpl(Annotation annotation) {
        RegisterConstructorMapper registerConstructorMapper = (RegisterConstructorMapper)annotation;
        this.constructorMapper = RegisterConstructorMapperImpl.createFactory(registerConstructorMapper);
    }

    static RowMapperFactory createFactory(RegisterConstructorMapper annotation) {
        Class<?> constructorClass = annotation.value();
        String prefix = annotation.prefix();
        Class<?> factoryMethodClass = annotation.usingStaticMethodIn();
        if (Void.TYPE.equals(factoryMethodClass)) {
            return ConstructorMapper.factory(constructorClass, (String)prefix);
        }
        return ConstructorMapper.factory(constructorClass, factoryMethodClass, (String)prefix);
    }

    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        RowMappers mappers = (RowMappers)config.get(RowMappers.class);
        mappers.register(this.constructorMapper);
    }
}

