/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.locator;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlLocator {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer((ds, h) -> {
        h.execute("create table something (id int, name text)", new Object[0]);
        h.execute("insert into something (id, name) values (?, ?)", new Object[]{2, "Alice"});
        h.execute("insert into something (id, name) values (?, ?)", new Object[]{1, "Bob"});
    });

    @Test
    public void testLocateConfigDriven() throws Exception {
        Jdbi jdbi = this.pgExtension.getJdbi();
        ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((type, method, config) -> ((TestConfig)config.get(TestConfig.class)).sql);
        jdbi.useHandle(h -> {
            ((TestConfig)h.getConfig(TestConfig.class)).sql = "select * from something order by id";
            Assertions.assertThat((List)((List)jdbi.withExtension(TestDao.class, TestDao::list))).containsExactly((Object[])new Something[]{new Something(1, "Bob"), new Something(2, "Alice")});
        });
        jdbi.useHandle(h -> {
            ((TestConfig)h.getConfig(TestConfig.class)).sql = "select * from something order by name";
            Assertions.assertThat((List)((List)jdbi.withExtension(TestDao.class, TestDao::list))).containsExactly((Object[])new Something[]{new Something(2, "Alice"), new Something(1, "Bob")});
        });
    }

    public static class TestConfig
    implements JdbiConfig<TestConfig> {
        private String sql;

        public TestConfig() {
        }

        private TestConfig(TestConfig that) {
            this.sql = that.sql;
        }

        public TestConfig createCopy() {
            return new TestConfig(this);
        }
    }

    @RegisterBeanMapper(value=Something.class)
    public static interface TestDao {
        @SqlQuery
        public List<Something> list();
    }
}

