/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.ParameterCustomizerFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUseConfiguredDefaultParameterCustomizerFactory {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private AtomicInteger invocationCounter = new AtomicInteger(0);

    @BeforeEach
    public void setUp() {
        Jdbi db = this.h2Extension.getJdbi();
        ParameterCustomizerFactory defaultParameterCustomizerFactory = (sqlObjectType, method, param, index, type) -> {
            this.invocationCounter.incrementAndGet();
            return (stmt, arg) -> stmt.bind("mybind" + index, arg);
        };
        db.configure(SqlObjects.class, c -> c.setDefaultParameterCustomizerFactory(defaultParameterCustomizerFactory));
        this.handle = db.open();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void shouldUseConfiguredSqlParameterCustomizer() {
        SomethingDao h = (SomethingDao)this.handle.attach(SomethingDao.class);
        h.findByNameAndIdNoBindAnnotation(1, "Joy");
        Assertions.assertThat((int)this.invocationCounter.get()).isEqualTo(4);
    }

    @Test
    public void shouldUseSqlParameterCustomizerFromAnnotation() {
        SomethingDao h = (SomethingDao)this.handle.attach(SomethingDao.class);
        h.findByNameAndIdWithBindAnnotation(1, "Joy");
        Assertions.assertThat((int)this.invocationCounter.get()).isEqualTo(2);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface SomethingDao {
        @SqlQuery(value="select id, name from something where name = :mybind1 and id = :mybind0")
        public Something findByNameAndIdNoBindAnnotation(int var1, String var2);

        @SqlQuery(value="select id, name from something where name = :mybind1 and id = :mybind0")
        public Something findByNameAndIdWithBindAnnotation(@Bind(value="mybind0") int var1, @Bind(value="mybind1") String var2);
    }
}

