/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.Article;
import org.jdbi.v3.sqlobject.config.Comment;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisterConstructorMapper {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("create table articles (id integer not null, title varchar not null, content varchar not null)", new Object[0]);
        this.handle.execute("create table comments (id integer not null, article_id integer not null, content varchar not null)", new Object[0]);
        this.handle.execute("insert into articles (id, title, content) values (?, ?, ?)", new Object[]{1, "title 1", "content 1"});
        this.handle.execute("insert into articles (id, title, content) values (?, ?, ?)", new Object[]{2, "title 2", "content 2"});
        this.handle.execute("insert into comments (id, article_id, content) values (?, ?, ?)", new Object[]{10, 1, "comment 10"});
        this.handle.execute("insert into comments (id, article_id, content) values (?, ?, ?)", new Object[]{11, 1, "comment 11"});
        this.handle.execute("insert into comments (id, article_id, content) values (?, ?, ?)", new Object[]{20, 2, "comment 20"});
    }

    @Test
    public void registerConstructorMappers() {
        BlogDao dao = (BlogDao)this.handle.attach(BlogDao.class);
        Assertions.assertThat(dao.listArticles()).containsExactly((Object[])new Article[]{Article.newArticle(1L, "title 1", "content 1", new Comment[0]), Article.newArticle(2L, "title 2", "content 2", new Comment[0])});
        Assertions.assertThat(dao.getArticleWithComments(0L)).isEmpty();
        Assertions.assertThat(dao.getArticleWithComments(1L)).contains((Object)Article.newArticle(1L, "title 1", "content 1", Comment.newComment(10L, "comment 10"), Comment.newComment(11L, "comment 11")));
        Assertions.assertThat(dao.getArticleWithComments(2L)).contains((Object)Article.newArticle(2L, "title 2", "content 2", Comment.newComment(20L, "comment 20")));
    }

    public static interface BlogDao
    extends SqlObject {
        @SqlQuery(value="select * from articles order by id")
        @RegisterConstructorMapper(value=Article.class)
        public List<Article> listArticles();

        @RegisterConstructorMappers(value={@RegisterConstructorMapper(value=Article.class, prefix="a"), @RegisterConstructorMapper(value=Comment.class, prefix="c")})
        default public Optional<Article> getArticleWithComments(long id) {
            return (Optional)this.getHandle().select("select  a.id a_id,  a.title a_title,  a.content a_content,  c.id c_id,  c.content c_content from articles a left join comments c  on a.id = c.article_id where a.id = ? order by c.id", new Object[]{id}).reduceRows(Optional.empty(), (acc, rv) -> {
                Article a = acc.orElseGet(() -> (Article)rv.getRow(Article.class));
                if (rv.getColumn("c_id", Long.class) != null) {
                    a.getComments().add((Comment)rv.getRow(Comment.class));
                }
                return Optional.of(a);
            });
        }
    }
}

