/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.junit5.H2DatabaseExtension;
import org.jdbi.v3.sqlobject.config.RegisterCollector;
import org.jdbi.v3.sqlobject.config.RegisterCollectorFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RegisterCollectorTest {
    @RegisterExtension
    H2DatabaseExtension h2 = H2DatabaseExtension.withPlugins();
    Handle h;

    @BeforeEach
    void setup() {
        this.h = this.h2.getSharedHandle();
        this.h.execute("create table i (i int)", new Object[0]);
        this.h.execute("insert into i values(1)", new Object[0]);
        this.h.execute("insert into i values(2)", new Object[0]);
    }

    @Test
    void registerCollector() {
        Assertions.assertThat((String)((RegisterCollectorDao)this.h.attach(RegisterCollectorDao.class)).selectWithCollector()).isEqualTo("1 2");
    }

    @Test
    void registerCollectorFactory() {
        Assertions.assertThat((String)((RegisterCollectorDao)this.h.attach(RegisterCollectorDao.class)).selectWithCollectorFactory()).isEqualTo("1 2");
    }

    public static interface RegisterCollectorDao {
        @RegisterCollector(value=StringConcatCollector.class)
        @SqlQuery(value="select i from i order by i asc")
        public String selectWithCollector();

        @RegisterCollectorFactory(value=StringConcatCollectorFactory.class)
        @SqlQuery(value="select i from i order by i asc")
        public String selectWithCollectorFactory();
    }

    public static class StringConcatCollector
    implements Collector<Integer, List<Integer>, String> {
        @Override
        public Supplier<List<Integer>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<Integer>, Integer> accumulator() {
            return List::add;
        }

        @Override
        public BinaryOperator<List<Integer>> combiner() {
            return (a, b) -> {
                a.addAll(b);
                return a;
            };
        }

        @Override
        public Function<List<Integer>, String> finisher() {
            return i -> i.stream().map(Object::toString).collect(Collectors.joining(" "));
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    public static class StringConcatCollectorFactory
    implements CollectorFactory {
        public boolean accepts(Type containerType) {
            return containerType == String.class;
        }

        public Optional<Type> elementType(Type containerType) {
            return Optional.of(Integer.class);
        }

        public Collector<Integer, List<Integer>, String> build(Type containerType) {
            return Collector.of(ArrayList::new, List::add, (x, y) -> {
                x.addAll(y);
                return x;
            }, i -> i.stream().map(Object::toString).collect(Collectors.joining(" ")), new Collector.Characteristics[0]);
        }
    }
}

