/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestVariousOddities {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testAttach() {
        Spiffy s = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        s.insert(new Something(14, "Tom"));
        Something tom = s.byId(14L);
        Assertions.assertThat((String)tom.getName()).isEqualTo("Tom");
    }

    @Test
    public void testEquals() {
        Spiffy s1 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((Object)s1).isEqualTo((Object)s1);
        Assertions.assertThat((Object)s1).isNotSameAs((Object)s2);
        Assertions.assertThat((Object)s1).isNotEqualTo((Object)s2);
    }

    @Test
    public void testToString() {
        Spiffy s1 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((String)s1.toString()).isNotNull();
        Assertions.assertThat((String)s2.toString()).isNotNull();
        Assertions.assertThat((String)s1.toString()).isNotEqualTo((Object)s2.toString());
    }

    @Test
    public void testHashCode() {
        Spiffy s1 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((int)s1.hashCode()).isNotZero();
        Assertions.assertThat((int)s2.hashCode()).isNotZero();
        Assertions.assertThat((int)s1.hashCode()).isNotEqualTo(s2.hashCode());
    }

    @Test
    public void testConcurrentHashCode() throws ExecutionException, InterruptedException {
        Callable<SpiffyConcurrent> callable = () -> (SpiffyConcurrent)this.h2Extension.getSharedHandle().attach(SpiffyConcurrent.class);
        ExecutorService pool = Executors.newFixedThreadPool(2);
        Future<SpiffyConcurrent> f1 = pool.submit(callable);
        Future<SpiffyConcurrent> f2 = pool.submit(callable);
        pool.shutdown();
        SpiffyConcurrent s1 = f1.get();
        SpiffyConcurrent s2 = f2.get();
        Assertions.assertThat((int)s1.hashCode()).isNotZero();
        Assertions.assertThat((int)s2.hashCode()).isNotZero();
        Assertions.assertThat((int)s1.hashCode()).isNotEqualTo(s2.hashCode());
    }

    @Test
    public void testNullQueryReturn() {
        Handle h = this.h2Extension.getSharedHandle();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> h.attach(SpiffyBoom.class)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("returnNothing is annotated as if it should return a value, but the method is void.");
    }

    @Test
    public void testInterfaceAmbiguousMethods() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(AmbiguousMethods.class)).hasMessageContaining("AmbiguousMethods has ambiguous methods").isInstanceOf(JdbiException.class);
    }

    @Test
    public void testAmbiguityResolved() {
        ResolvedMethods methods = (ResolvedMethods)this.h2Extension.getSharedHandle().attach(ResolvedMethods.class);
        Assertions.assertThat((String)methods.value()).isEqualTo("resolved");
    }

    @Test
    public void onDemandCreateSqlObject() throws Exception {
        Assertions.assertThat((String)((OnDemandOddities)this.h2Extension.getJdbi().onDemand(OnDemandOddities.class)).versionA().value()).isEqualTo("intriguing");
    }

    @Test
    public void decoratedOnDemandWithHandleInTransaction() throws Exception {
        DecoratedOnDemandOddities onDemand = new DecoratedOnDemandOddities();
        onDemand.withHandle(h -> (AbstractStringAssert)h.inTransaction(txn -> Assertions.assertThat((String)onDemand.versionA().value()).isEqualTo("intriguing")));
    }

    @Test
    public void decoratedOnDemandInTransaction() throws Exception {
        DecoratedOnDemandOddities onDemand = new DecoratedOnDemandOddities();
        onDemand.inTransaction(txn -> Assertions.assertThat((String)onDemand.versionA().value()).isEqualTo("intriguing"));
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@BindSomething(value="it") Something var1);
    }

    public static interface SpiffyConcurrent
    extends SqlObject {
    }

    public static interface ResolvedMethods
    extends AmbiguousMethods {
        @Override
        @SqlQuery(value="select 'resolved'")
        public String value();
    }

    public static interface OnDemandOddities
    extends SqlObject,
    Transactional<OnDemandOddities> {
        @CreateSqlObject
        public VersionA versionA();
    }

    public static interface VersionA {
        @SqlQuery(value="select 'intriguing'")
        public String value();
    }

    public class DecoratedOnDemandOddities
    implements OnDemandOddities {
        private OnDemandOddities onDemand;

        public DecoratedOnDemandOddities() {
            this.onDemand = (OnDemandOddities)TestVariousOddities.this.h2Extension.getJdbi().onDemand(OnDemandOddities.class);
        }

        public Handle getHandle() {
            return this.onDemand.getHandle();
        }

        public <R, X extends Exception> R withHandle(HandleCallback<R, X> callback) throws X {
            return (R)this.onDemand.withHandle(callback);
        }

        public <X extends Exception> void useHandle(HandleConsumer<X> consumer) throws X {
            this.onDemand.useHandle(consumer);
        }

        @Override
        public VersionA versionA() {
            return this.onDemand.versionA();
        }
    }

    public static interface AmbiguousMethods
    extends VersionA,
    VersionB {
    }

    public static interface SpiffyBoom {
        @SqlQuery(value="SELECT 1")
        public void returnNothing();
    }

    public static interface VersionB {
        @SqlQuery(value="select 'indubitably'")
        public String value();
    }
}

