/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.core.statement.MessageFormatTemplateEngine;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUseTemplateEngine {
    @RegisterExtension
    public JdbiExtension sqliteExtension = JdbiExtension.sqlite().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @BeforeEach
    public void before() {
        this.jdbi = (Jdbi)this.sqliteExtension.getJdbi().setTemplateEngine(TemplateEngine.NOP);
    }

    @Test
    public void testUseMessageFormat() {
        String selected = (String)this.jdbi.withExtension(QueriesForMessageFormatTE.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo("foo");
    }

    @Test
    public void testUseDefinedAttributes() {
        String selected = (String)this.jdbi.withExtension(QueriesForDefinedAttributeTE.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo("foo");
    }

    public static interface QueriesForMessageFormatTE {
        @UseTemplateEngine(value=MessageFormatTemplateEngine.class)
        @SqlQuery(value="select * from (values(''{0}''))")
        public String select(@Define(value="0") String var1);
    }

    public static interface QueriesForDefinedAttributeTE {
        @UseTemplateEngine(value=DefinedAttributeTemplateEngine.class)
        @SqlQuery(value="select * from (values(\\'<v>\\'))")
        public String select(@Define(value="v") String var1);
    }
}

