/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AssertionsForClassTypes;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.DelegatingTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlObjectTransactions {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer(TestingInitializers.users());
    private Jdbi jdbi;
    private CountingTransactionHandler transactionHandler;

    @BeforeEach
    public void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
        this.jdbi.registerRowMapper(User.class, ConstructorMapper.of(User.class));
        this.transactionHandler = new CountingTransactionHandler(this.jdbi.getTransactionHandler());
        this.jdbi.setTransactionHandler((TransactionHandler)this.transactionHandler);
    }

    @Test
    public void createInHandleUsesTwoTransactions() {
        this.jdbi.useHandle(handle -> {
            TransactionDao dao = (TransactionDao)handle.attach(TransactionDao.class);
            dao.createUser(1, "Alice");
            dao.createUser(2, "Bob");
        });
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(2, 0);
    }

    @Test
    public void createInTransactionHandleUsesOneTransaction() {
        this.jdbi.useHandle(handle -> handle.useTransaction(transactionHandle -> {
            TransactionDao dao = (TransactionDao)transactionHandle.attach(TransactionDao.class);
            dao.createUser(1, "Alice");
            dao.createUser(2, "Bob");
        }));
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(1, 0);
    }

    @Test
    public void createInJdbiOnDemandUsesTwoTransactions() {
        TransactionDao dao = (TransactionDao)this.jdbi.onDemand(TransactionDao.class);
        dao.createUser(1, "Alice");
        dao.createUser(2, "Bob");
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(2, 0);
    }

    @Test
    public void createInJdbiOnDemandTransactionalUsesOneTransaction() {
        TransactionDao dao = (TransactionDao)this.jdbi.onDemand(TransactionDao.class);
        dao.useTransaction(transactionDao -> {
            transactionDao.createUser(1, "Alice");
            transactionDao.createUser(2, "Bob");
        });
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(1, 0);
    }

    @Test
    public void createInJdbiExtensionUsesTwoTransactions() {
        this.jdbi.useExtension(TransactionDao.class, dao -> {
            dao.createUser(1, "Alice");
            dao.createUser(2, "Bob");
        });
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(2, 0);
    }

    @Test
    public void createInJdbiExtensionTransactionalUsesOneTransaction() {
        this.jdbi.useExtension(TransactionDao.class, dao -> dao.useTransaction(transactionDao -> {
            transactionDao.createUser(1, "Alice");
            transactionDao.createUser(2, "Bob");
        }));
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(1, 0);
    }

    @Test
    public void nestedTransactionalUsesOneTransaction() {
        this.jdbi.useExtension(TransactionDao.class, dao -> dao.useTransaction(transactionDao1 -> {
            transactionDao1.createUser(1, "Alice");
            transactionDao1.useTransaction(transactionDao2 -> transactionDao2.createUser(2, "Bob"));
        }));
        List users = (List)this.jdbi.withHandle(handle -> handle.createQuery("SELECT * from users").mapTo(User.class).list());
        AssertionsForClassTypes.assertThat((int)users.size()).isEqualTo(2);
        this.transactionHandler.assertTransactionResult(1, 0);
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class CountingTransactionHandler
    extends DelegatingTransactionHandler {
        private final AtomicInteger beginTransactions = new AtomicInteger();
        private final AtomicInteger commitTransactions = new AtomicInteger();
        private final AtomicInteger rollbackTransactions = new AtomicInteger();

        CountingTransactionHandler(TransactionHandler delegate) {
            super(delegate);
        }

        public void begin(Handle handle) {
            super.begin(handle);
            this.beginTransactions.incrementAndGet();
        }

        public void commit(Handle handle) {
            super.commit(handle);
            this.commitTransactions.incrementAndGet();
        }

        public void rollback(Handle handle) {
            super.rollback(handle);
            this.rollbackTransactions.incrementAndGet();
        }

        public void assertTransactionResult(int commit, int rollback) {
            AssertionsForClassTypes.assertThat((int)this.beginTransactions.get()).isEqualTo(this.commitTransactions.get() + this.rollbackTransactions.get());
            AssertionsForClassTypes.assertThat((int)this.commitTransactions.get()).isEqualTo(commit);
            AssertionsForClassTypes.assertThat((int)this.rollbackTransactions.get()).isEqualTo(rollback);
        }
    }

    public static interface TransactionDao
    extends Transactional<TransactionDao> {
        @Transaction
        @SqlUpdate(value="INSERT INTO users VALUES (:id, :name)")
        public void createUser(int var1, String var2);
    }
}

