/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSqlObjectFactory {
    private Jdbi jdbi;

    @BeforeEach
    public void setUp() {
        this.jdbi = Jdbi.create(() -> {
            throw new UnsupportedOperationException();
        });
        this.jdbi.registerExtension((ExtensionFactory)new SqlObjectFactory());
    }

    @Test
    public void accepts() {
        ExtensionFactory factory = ((Extensions)this.jdbi.getConfig(Extensions.class)).findFactory(SqlObjectFactory.class).orElseGet(() -> (ExtensionFactory)Assertions.fail((String)"Could not retrieve factory"));
        Assertions.assertThat((boolean)factory.accepts(NotASqlObject.class)).isFalse();
        Assertions.assertThat((boolean)factory.accepts(SqlObjectClass.class)).isFalse();
        Assertions.assertThat((boolean)factory.accepts(HasAnnotatedMethod.class)).isTrue();
        Assertions.assertThat((boolean)factory.accepts(ExtendsSqlObject.class)).isTrue();
    }

    abstract class NotASqlObject {
        NotASqlObject() {
        }

        abstract String foo(String var1);
    }

    public abstract class SqlObjectClass
    implements SqlObject {
    }

    public static interface HasAnnotatedMethod {
        @SqlQuery(value="select foo from bar")
        public String foo();
    }

    public static interface ExtendsSqlObject
    extends SqlObject {
    }

    static interface NonPublicSqlObject
    extends SqlObject {
    }
}

