/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.DecoratorOrder;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.HandlerDecorators;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlMethodDecorators {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle testHandle;
    private static final ThreadLocal<List<String>> INVOCATIONS = ThreadLocal.withInitial(ArrayList::new);

    @BeforeEach
    public void setUp() {
        this.testHandle = this.h2Extension.getSharedHandle();
        INVOCATIONS.get().clear();
    }

    @Test
    public void testUnordered() {
        Dao dao = (Dao)this.testHandle.attach(Dao.class);
        dao.unordered();
        Assertions.assertThat(INVOCATIONS.get()).isIn(new Object[]{Arrays.asList("foo", "bar", "method"), Arrays.asList("bar", "foo", "method")});
    }

    @Test
    public void testOrderedFooBar() {
        Dao dao = (Dao)this.testHandle.attach(Dao.class);
        dao.orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    @Test
    public void testOrderedBarFoo() {
        Dao dao = (Dao)this.testHandle.attach(Dao.class);
        dao.orderedBarFoo();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"bar", "foo", "method"});
    }

    @Test
    public void testOrderedFooBarOnType() {
        OrderedOnType dao = (OrderedOnType)this.testHandle.attach(OrderedOnType.class);
        dao.orderedFooBarOnType();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    @Test
    public void testOrderedFooBarOnTypeOverriddenToBarFooOnMethod() {
        OrderedOnType dao = (OrderedOnType)this.testHandle.attach(OrderedOnType.class);
        dao.orderedBarFooOnMethod();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"bar", "foo", "method"});
    }

    @Test
    public void testTypeWrapsMethod() {
        TypeDecorator dao = (TypeDecorator)this.testHandle.attach(TypeDecorator.class);
        dao.typeWrapsMethod();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    @Test
    public void testAbortingDecorator() {
        Dao dao = (Dao)this.testHandle.attach(Dao.class);
        dao.abortingDecorator();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "abort"});
    }

    @Test
    public void testRegisteredDecorator() {
        ((HandlerDecorators)this.testHandle.getConfig(HandlerDecorators.class)).register((base, sqlObjectType, method) -> (target, args, handleSupplier) -> {
            TestSqlMethodDecorators.invoked("custom");
            return base.invoke(target, args, handleSupplier);
        });
        ((Dao)this.testHandle.attach(Dao.class)).orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"custom", "foo", "bar", "method"});
    }

    @Test
    public void testRegisteredDecoratorReturnsBase() {
        ((HandlerDecorators)this.testHandle.getConfig(HandlerDecorators.class)).register((base, sqlObjectType, method) -> base);
        ((Dao)this.testHandle.attach(Dao.class)).orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    static void invoked(String value) {
        INVOCATIONS.get().add(value);
    }

    public static interface Dao {
        @Foo
        @Bar
        @CustomSqlOperation
        public void unordered();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Foo.class, Bar.class})
        public void orderedFooBar();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Bar.class, Foo.class})
        public void orderedBarFoo();

        @Foo
        @Abort
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Foo.class, Abort.class, Bar.class})
        public void abortingDecorator();
    }

    @DecoratorOrder(value={Foo.class, Bar.class})
    public static interface OrderedOnType {
        @Foo
        @Bar
        @CustomSqlOperation
        public void orderedFooBarOnType();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Bar.class, Foo.class})
        public void orderedBarFooOnMethod();
    }

    @Foo
    public static interface TypeDecorator {
        @Bar
        @CustomSqlOperation
        public void typeWrapsMethod();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlOperation(value=Impl.class)
    public static @interface CustomSqlOperation {

        public static class Impl
        implements Handler {
            public Object invoke(Object target, Object[] args, HandleSupplier handleSupplier) {
                TestSqlMethodDecorators.invoked("method");
                return null;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Abort {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (target, args, handleSupplier) -> {
                    TestSqlMethodDecorators.invoked("abort");
                    return null;
                };
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Bar {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (target, args, handleSupplier) -> {
                    TestSqlMethodDecorators.invoked("bar");
                    return base.invoke(target, args, handleSupplier);
                };
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Foo {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (target, args, handleSupplier) -> {
                    TestSqlMethodDecorators.invoked("foo");
                    return base.invoke(target, args, handleSupplier);
                };
            }
        }
    }
}

