/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestSqlMethodAnnotations {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testMutuallyExclusiveAnnotations() {
        Assertions.assertThatThrownBy(() -> this.handle.attach(Broken.class)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testCustomAnnotation() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assertions.assertThat((String)dao.foo()).isEqualTo("foo");
    }

    public static interface Dao {
        @Foo
        public String foo();
    }

    public static interface Broken {
        @SqlQuery
        @SqlUpdate
        public void bogus();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlOperation(value=Impl.class)
    public static @interface Foo {

        public static class Impl
        implements Handler {
            public Object invoke(Object target, Object[] args, HandleSupplier handleSupplier) {
                return "foo";
            }
        }
    }
}

