/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestReentrancy {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @BeforeEach
    public void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
    }

    @Test
    public void testGetHandleProvidesSeperateHandle() {
        TheBasics dao = (TheBasics)this.jdbi.onDemand(TheBasics.class);
        Handle h = dao.getHandle();
        Assertions.assertThatThrownBy(() -> h.execute("insert into something (id, name) values (1, 'Stephen')", new Object[0])).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    public void testHandleReentrant() {
        TheBasics dao = (TheBasics)this.jdbi.onDemand(TheBasics.class);
        dao.withHandle(handle1 -> {
            dao.insert(new Something(7, "Martin"));
            handle1.createQuery("SELECT 1").mapToMap().list();
            return null;
        });
        Assertions.assertThat((int)dao.count()).isOne();
    }

    @Test
    public void testTxnReentrant() {
        TheBasics dao = (TheBasics)this.jdbi.onDemand(TheBasics.class);
        dao.withHandle(handle1 -> {
            handle1.useTransaction(h -> {
                dao.insert(new Something(1, "x"));
                List rs = h.createQuery("select name from something where id = 1").mapTo(String.class).list();
                Assertions.assertThat((List)rs).hasSize(1);
                h.createQuery("SELECT 1").mapTo(Integer.TYPE).list();
            });
            return null;
        });
    }

    private static interface TheBasics
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);

        @SqlQuery(value="select count(1) from something")
        public int count();
    }
}

