/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.qualifier.QualifiedConstructorParamThing;
import org.jdbi.v3.core.qualifier.QualifiedFieldThing;
import org.jdbi.v3.core.qualifier.QualifiedGetterThing;
import org.jdbi.v3.core.qualifier.QualifiedMethodThing;
import org.jdbi.v3.core.qualifier.QualifiedSetterParamThing;
import org.jdbi.v3.core.qualifier.QualifiedSetterThing;
import org.jdbi.v3.core.qualifier.Reversed;
import org.jdbi.v3.core.qualifier.ReversedStringArgumentFactory;
import org.jdbi.v3.core.qualifier.ReversedStringMapper;
import org.jdbi.v3.core.qualifier.Reverser;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterBeanMappers;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterColumnMappers;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterFieldMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindFields;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.MapTo;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestQualifiers {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Mock
    private Consumer<String> consumer;
    private Handle handle;
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
    }

    @Test
    public void bindQualified() {
        this.dao.insert(1, "abc");
        Assertions.assertThat((String)((String)this.handle.select("SELECT name FROM something WHERE id = 1", new Object[0]).mapTo(String.class).one())).isEqualTo("cba");
    }

    @Test
    public void bindQualifiedBatch() {
        this.dao.insert((Iterable<Integer>)ImmutableList.of((Object)1, (Object)2, (Object)3), (Iterable<String>)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"));
        Assertions.assertThat((List)this.handle.select("SELECT name FROM something ORDER BY id", new Object[0]).mapTo(String.class).list()).containsExactly((Object[])new String[]{"oof", "rab", "zab"});
    }

    @Test
    public void singleQualifiedResult() {
        this.handle.execute("insert into something (id, name) values (1, 'abc')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(1)).isEqualTo("cba");
    }

    @Test
    public void multipleQualifiedResults() {
        this.handle.prepareBatch("insert into something (id, name) values (?, ?)").add(new Object[]{1, "foo"}).add(new Object[]{2, "bar"}).add(new Object[]{3, "baz"}).execute();
        Assertions.assertThat(this.dao.listNames()).containsExactly((Object[])new String[]{"oof", "rab", "zab"});
        Assertions.assertThat(this.dao.resultIterableNames()).containsExactly((Object[])new String[]{"oof", "rab", "zab"});
        Assertions.assertThat(this.dao.resultIteratorNames()).toIterable().containsExactly((Object[])new String[]{"oof", "rab", "zab"});
        Assertions.assertThat(this.dao.iteratorNames()).toIterable().containsExactly((Object[])new String[]{"oof", "rab", "zab"});
        Assertions.assertThat(this.dao.streamNames()).containsExactly((Object[])new String[]{"oof", "rab", "zab"});
        this.dao.consumeNames(this.consumer);
        ((Consumer)Mockito.verify(this.consumer)).accept("oof");
        ((Consumer)Mockito.verify(this.consumer)).accept("rab");
        ((Consumer)Mockito.verify(this.consumer)).accept("zab");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.consumer});
    }

    @Test
    public void bindBeanQualifiedProperty() {
        BeanDao beanDao = (BeanDao)this.handle.attach(BeanDao.class);
        beanDao.insertBeanQualifiedGetter(new QualifiedGetterThing(1, "foo"));
        beanDao.insertBeanQualifiedSetter(new QualifiedSetterThing(2, "bar"));
        beanDao.insertBeanQualifiedSetterParam(new QualifiedSetterParamThing(3, "baz"));
        Assertions.assertThat((List)this.handle.select("select name from something order by id", new Object[0]).mapTo(String.class).list()).containsExactly((Object[])new String[]{"oof", "rab", "zab"});
    }

    @Test
    public void mapBeanQualifiedProperty() {
        this.handle.execute("insert into something (id, name) values (1, 'abc')", new Object[0]);
        BeanDao beanDao = (BeanDao)this.handle.attach(BeanDao.class);
        Assertions.assertThat((Object)beanDao.getBeanQualifiedGetter(1)).isEqualTo((Object)new QualifiedGetterThing(1, "cba"));
        Assertions.assertThat((Object)beanDao.getBeanQualifiedSetter(1)).isEqualTo((Object)new QualifiedSetterThing(1, "cba"));
        Assertions.assertThat((Object)beanDao.getBeanQualifiedSetterParam(1)).isEqualTo((Object)new QualifiedSetterParamThing(1, "cba"));
    }

    @Test
    public void bindQualifiedMethod() {
        FluentDao fluentDao = (FluentDao)this.handle.attach(FluentDao.class);
        fluentDao.insertBindMethods(new QualifiedMethodThing(1, "abc"));
        Assertions.assertThat((String)((String)this.handle.select("select name from something", new Object[0]).mapTo(String.class).one())).isEqualTo("cba");
    }

    @Test
    public void mapConstructorMappedQualifiedParam() {
        this.handle.execute("insert into something (id, name) values (1, 'abc')", new Object[0]);
        FluentDao fluentDao = (FluentDao)this.handle.attach(FluentDao.class);
        Assertions.assertThat((Object)fluentDao.getConstructorInjected(1)).isEqualTo((Object)new QualifiedConstructorParamThing(1, "cba"));
    }

    @Test
    public void bindQualifiedField() {
        FieldDao fieldDao = (FieldDao)this.handle.attach(FieldDao.class);
        fieldDao.insertBindFields(new QualifiedFieldThing(1, "abc"));
        Assertions.assertThat((String)((String)this.handle.select("select name from something", new Object[0]).mapTo(String.class).one())).isEqualTo("cba");
    }

    @Test
    public void mapQualifiedField() {
        this.handle.execute("insert into something (id, name) values (1, 'abc')", new Object[0]);
        FieldDao fieldDao = (FieldDao)this.handle.attach(FieldDao.class);
        Assertions.assertThat((Object)fieldDao.getQualifiedField(1)).isEqualTo((Object)new QualifiedFieldThing(1, "cba"));
    }

    @Test
    public void mapTo() {
        this.handle.execute("insert into something (id, name) values (1, 'abc')", new Object[0]);
        MapToDao mapToDao = (MapToDao)this.handle.attach(MapToDao.class);
        Assertions.assertThat((Object)mapToDao.get(1, QualifiedGetterThing.class)).isEqualTo((Object)new QualifiedGetterThing(1, "cba"));
        Assertions.assertThat((Object)mapToDao.get(1, QualifiedSetterThing.class)).isEqualTo((Object)new QualifiedSetterThing(1, "cba"));
        Assertions.assertThat((Object)mapToDao.get(1, QualifiedSetterParamThing.class)).isEqualTo((Object)new QualifiedSetterParamThing(1, "cba"));
        Assertions.assertThat((Object)mapToDao.get(1, QualifiedConstructorParamThing.class)).isEqualTo((Object)new QualifiedConstructorParamThing(1, "cba"));
        Assertions.assertThat((Object)mapToDao.get(1, QualifiedFieldThing.class)).isEqualTo((Object)new QualifiedFieldThing(1, "cba"));
    }

    @Test
    public void singleValue() {
        this.handle.execute("CREATE TABLE stuff (id INT, name VARCHAR)", new Object[0]);
        this.handle.execute("INSERT INTO stuff (id, name) VALUES (1, 'abc,123,xyz')", new Object[0]);
        this.handle.execute("INSERT INTO stuff (id, name) VALUES (2, 'foo,bar,baz')", new Object[0]);
        SingleValueDao singleValueDao = (SingleValueDao)this.handle.attach(SingleValueDao.class);
        Assertions.assertThat(singleValueDao.multipleRows()).containsExactly((Object[])new String[]{"zyx,321,cba", "zab,rab,oof"});
        Assertions.assertThat(singleValueDao.singleRow()).containsExactly((Object[])new String[]{"cba", "321", "zyx"});
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    public static interface Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(int var1, @Reversed String var2);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public void insert(Iterable<Integer> var1, @Reversed Iterable<String> var2);

        @SqlQuery(value="select name from something where id = :id")
        @Reversed
        public String getName(int var1);

        @SqlQuery(value="select name from something order by id")
        @Reversed
        public List<String> listNames();

        @SqlQuery(value="select name from something order by id")
        @Reversed
        public ResultIterable<String> resultIterableNames();

        @SqlQuery(value="select name from something order by id")
        @Reversed
        public ResultIterator<String> resultIteratorNames();

        @SqlQuery(value="select name from something order by id")
        @Reversed
        public Iterator<String> iteratorNames();

        @SqlQuery(value="select name from something order by id")
        @Reversed
        public Stream<String> streamNames();

        @SqlQuery(value="select name from something order by id")
        public void consumeNames(@Reversed Consumer<String> var1);
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    public static interface BeanDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertBeanQualifiedGetter(@BindBean QualifiedGetterThing var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertBeanQualifiedSetter(@BindBean QualifiedSetterThing var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertBeanQualifiedSetterParam(@BindBean QualifiedSetterParamThing var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterBeanMapper(value=QualifiedGetterThing.class)
        public QualifiedGetterThing getBeanQualifiedGetter(int var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterBeanMapper(value=QualifiedSetterThing.class)
        public QualifiedSetterThing getBeanQualifiedSetter(int var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterBeanMapper(value=QualifiedSetterParamThing.class)
        public QualifiedSetterParamThing getBeanQualifiedSetterParam(int var1);
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    public static interface FluentDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertBindMethods(@BindMethods QualifiedMethodThing var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterConstructorMapper(value=QualifiedConstructorParamThing.class)
        public QualifiedConstructorParamThing getConstructorInjected(int var1);
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    public static interface FieldDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertBindFields(@BindFields QualifiedFieldThing var1);

        @SqlQuery(value="select * from something where id = :id")
        @RegisterFieldMapper(value=QualifiedFieldThing.class)
        public QualifiedFieldThing getQualifiedField(int var1);
    }

    @RegisterArgumentFactory(value=ReversedStringArgumentFactory.class)
    @RegisterColumnMapper(value=ReversedStringMapper.class)
    @RegisterBeanMappers(value={@RegisterBeanMapper(value=QualifiedGetterThing.class), @RegisterBeanMapper(value=QualifiedSetterThing.class), @RegisterBeanMapper(value=QualifiedSetterParamThing.class)})
    @RegisterConstructorMapper(value=QualifiedConstructorParamThing.class)
    @RegisterFieldMapper(value=QualifiedFieldThing.class)
    public static interface MapToDao {
        @SqlQuery(value="select * from something where id = :id")
        public <T> T get(int var1, @MapTo Class<T> var2);
    }

    @RegisterColumnMappers(value={@RegisterColumnMapper(value=ReversedStringMapper.class), @RegisterColumnMapper(value=ReversedListStringMapper.class)})
    public static interface SingleValueDao {
        @SqlQuery(value="select name from stuff order by id")
        @Reversed
        public List<String> multipleRows();

        @SqlQuery(value="select name from stuff order by id")
        @Reversed
        @SingleValue
        public List<String> singleRow();
    }

    @Reversed
    public static class ReversedListStringMapper
    implements ColumnMapper<List<String>> {
        public List<String> map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            return Splitter.on((String)",").splitToList((CharSequence)r.getString(columnNumber)).stream().map(Reverser::reverse).collect(Collectors.toList());
        }
    }
}

