/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestPrimitiveQueryResult {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    PrimitiveDao dao;

    @BeforeEach
    public void setUp() {
        this.dao = (PrimitiveDao)this.h2Extension.getSharedHandle().attach(PrimitiveDao.class);
        this.dao.insert(1, "foo");
    }

    @Test
    public void testBoolean() {
        Assertions.assertThat((boolean)this.dao.getBoolean(1)).isTrue();
        Assertions.assertThatThrownBy(() -> this.dao.getBoolean(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testByte() {
        Assertions.assertThat((byte)this.dao.getByte(1)).isEqualTo((byte)1);
        Assertions.assertThatThrownBy(() -> this.dao.getByte(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testChar() {
        Assertions.assertThat((char)this.dao.getChar(1)).isEqualTo('a');
        Assertions.assertThatThrownBy(() -> this.dao.getChar(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testShort() {
        Assertions.assertThat((short)this.dao.getShort(1)).isEqualTo((short)1);
        Assertions.assertThatThrownBy(() -> this.dao.getShort(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testInt() {
        Assertions.assertThat((int)this.dao.getInt(1)).isOne();
        Assertions.assertThatThrownBy(() -> this.dao.getInt(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testLong() {
        Assertions.assertThat((long)this.dao.getLong(1)).isEqualTo(1L);
        Assertions.assertThatThrownBy(() -> this.dao.getLong(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testFloat() {
        Assertions.assertThat((float)this.dao.getFloat(1)).isEqualTo(1.0f);
        Assertions.assertThatThrownBy(() -> this.dao.getFloat(2)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testDouble() {
        Assertions.assertThat((double)this.dao.getDouble(1)).isEqualTo(1.0);
        Assertions.assertThatThrownBy(() -> this.dao.getDouble(2)).isInstanceOf(IllegalStateException.class);
    }

    public static interface PrimitiveDao {
        @SqlUpdate(value="insert into something(id, name) values (:id, :name)")
        public void insert(int var1, String var2);

        @SqlQuery(value="select 1 from something where id = :id")
        public boolean getBoolean(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public byte getByte(int var1);

        @SqlQuery(value="select 'a' from something where id = :id")
        public char getChar(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public short getShort(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public int getInt(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public long getLong(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public float getFloat(int var1);

        @SqlQuery(value="select 1 from something where id = :id")
        public double getDouble(int var1);
    }
}

