/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.sqlobject.customizer.OutParameter;
import org.jdbi.v3.sqlobject.customizer.OutParameterList;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestPostgresRefcursorProc {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).installPlugins();
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.pgExtension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void multipleResultSetReturn() {
        this.handle.execute("create function gather_data (head out refcursor, tail out refcursor) language plpgsql as $$ begin open head for select 1 union select 2; open tail for select 3 union select 4; end; $$", new Object[0]);
        Assertions.assertThat((boolean)((Dao)this.handle.attach(Dao.class)).gatherData(op -> {
            Assertions.assertThat((List)op.getRowSet("head").mapTo(Integer.TYPE).list()).containsExactly((Object[])new Integer[]{1, 2});
            Assertions.assertThat((List)op.getRowSet("tail").mapTo(Integer.TYPE).list()).containsExactly((Object[])new Integer[]{3, 4});
            return true;
        })).isTrue();
    }

    public static interface Dao {
        @SqlCall(value="{call gather_data(:head, :tail)}")
        @OutParameterList(value={@OutParameter(name="head", sqlType=2012), @OutParameter(name="tail", sqlType=2012)})
        @Transaction
        public boolean gatherData(Function<OutParameters, Boolean> var1);
    }
}

