/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import de.softwareforge.testing.postgres.junit5.MultiDatabaseBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.OutParameter;
import org.jdbi.v3.sqlobject.customizer.OutParameterList;
import org.jdbi.v3.sqlobject.statement.SqlCall;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestOutParameterAnnotation {
    @RegisterExtension
    public static EmbeddedPgExtension pg = (EmbeddedPgExtension)MultiDatabaseBuilder.instanceWithDefaults().build();
    @RegisterExtension
    public JdbiExtension pgExtension = JdbiExtension.postgres((EmbeddedPgExtension)pg).withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer((ds, h) -> {
        h.execute("CREATE FUNCTION set100(OUT outparam INT) AS $$ BEGIN outparam := 100; END; $$ LANGUAGE plpgsql", new Object[0]);
        h.execute("CREATE FUNCTION swap(IN a INT, IN b INT, OUT c INT, OUT d INT) AS $$ BEGIN c := b; d := a; END; $$ LANGUAGE plpgsql", new Object[0]);
    });
    Jdbi db;
    Handle handle;

    @BeforeEach
    void setUp() {
        this.db = this.pgExtension.getJdbi();
        this.handle = this.pgExtension.getSharedHandle();
    }

    @Test
    void testOutParameterReturnExtension() {
        this.db.useExtension(MyDao.class, myDao -> {
            OutParameters outParameters = myDao.callStoredProc();
            Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100);
        });
    }

    @Test
    void testOutParameterReturnOnDemand() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        OutParameters outParameters = myDao.callStoredProc();
        Assertions.assertThatThrownBy(() -> Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100)).isInstanceOf(UnableToExecuteStatementException.class);
    }

    @Test
    void testOutParameterReturnHandleAttach() {
        MyDao myDao = (MyDao)this.handle.attach(MyDao.class);
        OutParameters outParameters = myDao.callStoredProc();
        Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100);
    }

    @Test
    void testUseOutParameterExtension() {
        this.db.useExtension(MyDao.class, myDao -> myDao.useStoredProc(outParameters -> Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100)));
    }

    @Test
    void testUseOutParameterOnDemand() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        myDao.useStoredProc(outParameters -> Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100));
    }

    @Test
    void testUseOutParameterHandleAttach() {
        MyDao myDao = (MyDao)this.handle.attach(MyDao.class);
        myDao.useStoredProc(outParameters -> Assertions.assertThat((Integer)outParameters.getInt("outparam")).isEqualTo(100));
    }

    @Test
    void testWithOutParameterExtension() {
        this.db.useExtension(MyDao.class, myDao -> Assertions.assertThat((Integer)myDao.withStoredProc(outParameters -> outParameters.getInt("outparam"))).isEqualTo(100));
    }

    @Test
    void testWithOutParameterOnDemand() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        Assertions.assertThat((Integer)myDao.withStoredProc(outParameters -> outParameters.getInt("outparam"))).isEqualTo(100);
    }

    @Test
    void testWithOutParameterHandleAttach() {
        MyDao myDao = (MyDao)this.handle.attach(MyDao.class);
        Assertions.assertThat((Integer)myDao.withStoredProc(outParameters -> outParameters.getInt("outparam"))).isEqualTo(100);
    }

    @Test
    void testReturnMultipleOutParametersExtension() {
        this.db.useExtension(MyDao.class, myDao -> {
            OutParameters outParameters = myDao.callMultipleOutParameters(1, 9);
            Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
            Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
        });
    }

    @Test
    void testReturnMultipleOutParametersOnDemandFails() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        OutParameters outParameters = myDao.callMultipleOutParameters(1, 9);
        Assertions.assertThatThrownBy(() -> {
            Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
            Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
        }).isInstanceOf(UnableToExecuteStatementException.class);
    }

    @Test
    void testReturnMultipleOutParametersHandleAttach() {
        MyDao myDao = (MyDao)this.handle.attach(MyDao.class);
        OutParameters outParameters = myDao.callMultipleOutParameters(1, 9);
        Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
        Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
    }

    @Test
    void testUseMultipleOutParametersExtension() {
        this.db.useExtension(MyDao.class, myDao -> myDao.useMultipleOutParameters(1, 9, outParameters -> {
            Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
            Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
        }));
    }

    @Test
    void testUseMultipleOutParametersOnDemand() {
        MyDao myDao = (MyDao)this.db.onDemand(MyDao.class);
        myDao.useMultipleOutParameters(1, 9, outParameters -> {
            Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
            Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
        });
    }

    @Test
    void testUseMultipleOutParametersHandleAttach() {
        MyDao myDao = (MyDao)this.handle.attach(MyDao.class);
        myDao.useMultipleOutParameters(1, 9, outParameters -> {
            Assertions.assertThat((Integer)outParameters.getInt("c")).isEqualTo(9);
            Assertions.assertThat((Integer)outParameters.getInt("d")).isOne();
        });
    }

    public static interface MyDao {
        @SqlCall(value="{call set100(:outparam)}")
        @OutParameter(name="outparam", sqlType=4)
        public OutParameters callStoredProc();

        @SqlCall(value="{call set100(:outparam)}")
        @OutParameter(name="outparam", sqlType=4)
        public void useStoredProc(Consumer<OutParameters> var1);

        @SqlCall(value="{call set100(:outparam)}")
        @OutParameter(name="outparam", sqlType=4)
        public <T> T withStoredProc(Function<OutParameters, T> var1);

        @SqlCall(value="{call swap(:a, :b, :c, :d)}")
        @OutParameterList(value={@OutParameter(name="c", sqlType=4), @OutParameter(name="d", sqlType=4)})
        public OutParameters callMultipleOutParameters(int var1, int var2);

        @SqlCall(value="{call swap(:a, :b, :c, :d)}")
        @OutParameterList(value={@OutParameter(name="c", sqlType=4), @OutParameter(name="d", sqlType=4)})
        public void useMultipleOutParameters(int var1, int var2, Consumer<OutParameters> var3);
    }
}

