/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestNull {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private DAO dao;

    @BeforeEach
    public void setUp() {
        this.dao = (DAO)this.h2Extension.getSharedHandle().attach(DAO.class);
        this.dao.insert(1L, "brian");
        this.dao.insert(2L, null);
    }

    @Test
    public void testNotNullResult() {
        Assertions.assertThat((String)this.dao.findNameById(1L)).isEqualTo("brian");
    }

    @Test
    public void testNullResult() {
        Assertions.assertThat((String)this.dao.findNameById(2L)).isNull();
    }

    @Test
    public void testNoResult() {
        Assertions.assertThat((String)this.dao.findNameById(3L)).isNull();
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") long var1);
    }
}

