/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestMistypedNamedParameter {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.dao = (Dao)this.h2Extension.getSharedHandle().attach(Dao.class);
        this.h2Extension.getSharedHandle().useTransaction(h -> {
            h.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
            h.execute("insert into something (id, name) values (2, 'Bob')", new Object[0]);
            h.execute("insert into something (id, name) values (3, 'Charles')", new Object[0]);
        });
    }

    @Test
    public void testWarnAboutUnmatchedBinding() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.dao.deleteSomething(2)).isInstanceOf(UnableToCreateStatementException.class)).hasMessageStartingWith("Superfluous named parameters provided while the query declares none");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao {
        @SqlUpdate(value="delete from something where id = id")
        public void deleteSomething(@Bind(value="id") int var1);
    }
}

