/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestInClauseExpansion {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().installPlugins().withInitializer(TestingInitializers.something());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testInClauseExpansion() {
        this.handle.execute("insert into something (name, id) values ('Brian', 1), ('Jeff', 2), ('Tom', 3)", new Object[0]);
        DAO dao = (DAO)this.handle.attach(DAO.class);
        Assertions.assertThat(dao.findIdsForNames(Arrays.asList(1, 2))).containsExactly((Object[])new String[]{"Brian", "Jeff"});
    }

    public static interface DAO {
        @SqlQuery(value="select name from something where id in (<names>)")
        public ImmutableSet<String> findIdsForNames(@BindList List<Integer> var1);
    }
}

