/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestEnumMapping {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer(TestingInitializers.something());

    @Test
    public void testEnums() {
        Spiffy spiffy = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        int bobId = spiffy.addCoolName(CoolName.BOB);
        int joeId = spiffy.addCoolName(CoolName.JOE);
        Assertions.assertThat((Comparable)((Object)spiffy.findById(bobId))).isSameAs((Object)CoolName.BOB);
        Assertions.assertThat((Comparable)((Object)spiffy.findById(joeId))).isSameAs((Object)CoolName.JOE);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlUpdate(value="insert into something(name) values(:name)")
        @GetGeneratedKeys
        public int addCoolName(@Bind(value="name") CoolName var1);

        @SqlQuery(value="select name from something where id = :id")
        public CoolName findById(@Bind(value="id") int var1);
    }

    public static enum CoolName {
        BOB,
        FRANK,
        JOE;

    }
}

