/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestCustomBinder {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFoo() {
        this.h2Extension.getSharedHandle().execute("insert into something (id, name) values (2, 'Martin')", new Object[0]);
        this.h2Extension.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Something s = spiffy.findSame(new Something(2, "Unknown"));
            Assertions.assertThat((String)s.getName()).isEqualTo("Martin");
        });
    }

    @Test
    public void testCustomBindingAnnotation() {
        Spiffy s = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        s.insert(new Something(2, "Keith"));
        Assertions.assertThat((String)s.findNameById(2)).isEqualTo("Keith");
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :it.id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something findSame(@BindSomething(value="it") Something var1);

        @SqlUpdate(value="insert into something (id, name) values (:s.id, :s.name)")
        public int insert(@BindSomething(value="s") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

