/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBridgeException {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @BeforeEach
    public void setUp() {
        this.h2Extension.getSharedHandle().execute("CREATE TABLE uniq (id INTEGER PRIMARY KEY)", new Object[0]);
    }

    @Test
    public void testBridgeExceptionPassthru() {
        ExceptionalBridge dao = (ExceptionalBridge)this.h2Extension.getSharedHandle().attach(ExceptionallyTypedBridge.class);
        Integer arg = 3;
        Assertions.assertThatThrownBy(() -> {
            for (int i = 0; i < 2; ++i) {
                dao.insert(arg);
            }
        }).isInstanceOf(UnableToExecuteStatementException.class);
    }

    public static interface ExceptionallyTypedBridge
    extends ExceptionalBridge<Integer> {
        @Override
        @SqlUpdate(value="INSERT INTO uniq (id) VALUES(:value)")
        public void insert(Integer var1);
    }

    public static interface ExceptionalBridge<T>
    extends SqlObject {
        public void insert(T var1);
    }
}

