/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.reflect.FieldMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.TestBindBeanList;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMethodsList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindMethodsList {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @BeforeEach
    public void setUp() {
        Handle handle = this.h2Extension.getSharedHandle();
        handle.registerRowMapper(FieldMapper.factory(TestBindBeanList.Thing.class));
        handle.execute("create table thing (id identity primary key, foo varchar(50), bar varchar(50), baz varchar(50))", new Object[0]);
    }

    @Test
    public void bindMethodsListWithNoValue() {
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().createQuery("insert into thing (id, foo, bar, baz) VALUES <items>").bindMethodsList("items", Collections.emptyList(), Arrays.asList("getFoo", "getBar"))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void bindMethodsListWithNoMethods() {
        Thing thing = new Thing(1, "foo", "bar", "baz");
        Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().createQuery("insert into (id, foo, bar, baz) VALUES <items>").bindMethodsList("items", Collections.singletonList(thing), Collections.emptyList())).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void happyPath() {
        Thing thing1 = new Thing(1, "foo1", "bar1", "baz1");
        Thing thing2 = new Thing(2, "foo2", "bar2", "baz2");
        List<Thing> things = Arrays.asList(thing1, thing2);
        ThingDAO dao = (ThingDAO)this.h2Extension.getJdbi().onDemand(ThingDAO.class);
        Assertions.assertThat((int)dao.insert(things)).isEqualTo(things.size());
        Assertions.assertThat((String)dao.getBazById(2)).isEqualTo("baz2");
    }

    public static class Thing {
        private int id;
        private String fooTest;
        private String barTest;
        private String bazTest;

        public Thing(int id, String fooTest, String barTest, String bazTest) {
            this.id = id;
            this.fooTest = fooTest;
            this.barTest = barTest;
            this.bazTest = bazTest;
        }

        public int getId() {
            return this.id;
        }

        public String getFoo() {
            return this.fooTest;
        }

        public String getBar() {
            return this.barTest;
        }

        public String getBaz() {
            return this.bazTest;
        }
    }

    public static interface ThingDAO {
        @SqlUpdate(value="insert into thing (id, foo, bar, baz) VALUES <items>")
        public int insert(@BindMethodsList(value="items", methodNames={"getId", "getFoo", "getBar", "getBaz"}) Collection<Thing> var1);

        @SqlQuery(value="select baz from thing where id = :id")
        public String getBazById(@Bind(value="id") int var1);
    }
}

