/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindMap {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
    }

    @Test
    public void testBindMap() {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        this.dao.update(1, Collections.singletonMap("name", "Alicia"));
        Assertions.assertThat((String)this.dao.get(1L).getName()).isEqualTo("Alicia");
    }

    @Test
    public void testBindMapPrefixed() {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        this.dao.updatePrefix(1, Collections.singletonMap("name", "Alicia"));
        Assertions.assertThat((String)this.dao.get(1L).getName()).isEqualTo("Alicia");
    }

    @Test
    public void testBindMapKeyInKeysAndMap() {
        this.handle.execute("insert into something (id, name) values (2, 'Bob')", new Object[0]);
        this.dao.updateNameKey(2, Collections.singletonMap("name", "Rob"));
        Assertions.assertThat((String)this.dao.get(2L).getName()).isEqualTo("Rob");
    }

    @Test
    public void testBindMapKeyInKeysNotInMap() {
        this.handle.execute("insert into something(id, name) values (2, 'Bob')", new Object[0]);
        this.dao.updateNameKey(2, Collections.emptyMap());
        Assertions.assertThat((String)this.dao.get(2L).getName()).isNull();
    }

    @Test
    public void testBindMapKeyInMapNotInKeys() {
        this.handle.execute("insert into something(id, name) values (3, 'Carol')", new Object[0]);
        this.dao.updateNameKey(3, (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"Cheryl", (Object)"integerValue", (Object)3));
        Assertions.assertThat((String)this.dao.get(3L).getName()).isEqualTo("Cheryl");
        Assertions.assertThat((Integer)this.dao.get(3L).getIntegerValue()).isNull();
    }

    @Test
    public void testBindMapKeyNotInMapOrKeys() {
        this.handle.execute("insert into something(id, name) values (3, 'Carol')", new Object[0]);
        Map m = Collections.emptyMap();
        Assertions.assertThatThrownBy(() -> this.dao.update(3, m)).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    public void testBindMapConvertKeysStringKeys() {
        this.handle.execute("insert into something(id, name) values (4, 'Dave')", new Object[0]);
        this.dao.updateConvertKeys(4, Collections.singletonMap("name", "David"));
        Assertions.assertThat((String)this.dao.get(4L).getName()).isEqualTo("David");
    }

    @Test
    public void testBindMapConvertKeysNonStringKeys() {
        this.handle.execute("insert into something(id, name) values (4, 'Dave')", new Object[0]);
        this.dao.updateConvertKeys(4, Collections.singletonMap(new MapKey("name"), "David"));
        Assertions.assertThat((String)this.dao.get(4L).getName()).isEqualTo("David");
    }

    @Test
    public void testBindMapNonStringKeys() {
        this.handle.execute("insert into something(id, name) values (5, 'Edward')", new Object[0]);
        Map<MapKey, String> m = Collections.singletonMap(new MapKey("name"), "Jacob");
        Assertions.assertThatThrownBy(() -> this.dao.update(5, m)).isInstanceOf(IllegalArgumentException.class);
    }

    public static interface Dao {
        @SqlUpdate(value="update something set name=:name where id=:id")
        public void update(@Bind int var1, @BindMap Map<Object, Object> var2);

        @SqlUpdate(value="update something set name=:map.name where id=:id")
        public void updatePrefix(@Bind int var1, @BindMap(value="map") Map<String, Object> var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public void updateNameKey(@Bind int var1, @BindMap(keys={"name"}) Map<String, Object> var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public void updateConvertKeys(@Bind int var1, @BindMap(convertKeys=true) Map<Object, Object> var2);

        @SqlQuery(value="select * from something where id=:id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something get(long var1);
    }

    public static class MapKey {
        private final String value;

        MapKey(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

