/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindFunctions {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
    }

    @Test
    public void testBindFunctions() {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo("Alice");
        this.dao.update(new FluentSomething(1, "Alicia"));
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo("Alicia");
    }

    public static interface Dao {
        @SqlUpdate(value="update something set name=:name where id=:id")
        public void update(@BindMethods FluentSomething var1);

        @SqlQuery(value="select name from something where id = :id")
        public String getName(long var1);
    }

    public static class FluentSomething {
        private final int id;
        private final String name;

        public FluentSomething(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }
    }
}

