/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindExpression {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testExpression() {
        DB db = (DB)this.h2Extension.getSharedHandle().attach(DB.class);
        db.insert(new Something(1, "syrup"), new Something(2, "whipped cream"));
        Something selected = db.findBySpecifier(new SyrupSpecifying());
        Assertions.assertThat((Object)selected).isEqualTo((Object)new Something(1, "syrup"));
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface DB {
        @SqlBatch(value="insert into something (id, name) values(:id, :name)")
        public void insert(Something ... var1);

        @SqlQuery(value="select id, name from something where name = :breakfast.waffle.topping limit 1")
        public Something findBySpecifier(@BindNameSpecifying(value="breakfast") SyrupSpecifying var1);
    }

    private static class SyrupSpecifying {
        private SyrupSpecifying() {
        }

        private String getNameValue() {
            return "syrup";
        }
    }

    public static class NameSpecifyingCustomizerFactory
    implements SqlStatementCustomizerFactory {
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
            String bindingName = ((BindNameSpecifying)annotation).value();
            Assertions.assertThat((String)bindingName).isEqualTo("breakfast");
            return (stmt, specifier) -> stmt.bindNamedArgumentFinder((paramName, context) -> {
                Assertions.assertThat((String)paramName).isEqualTo("breakfast.waffle.topping");
                SyrupSpecifying syrupSpecifier = (SyrupSpecifying)specifier;
                return Optional.of((position, statement, ctx) -> statement.setObject(position, syrupSpecifier.getNameValue()));
            });
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlStatementCustomizingAnnotation(value=NameSpecifyingCustomizerFactory.class)
    private static @interface BindNameSpecifying {
        public String value();
    }
}

