/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindAutomaticNames {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
    }

    @Test
    public void testAnnotationNoValue() {
        Spiffy spiffy = (Spiffy)this.handle.attach(Spiffy.class);
        Something s = spiffy.findById(7);
        Assertions.assertThat((String)s.getName()).isEqualTo("Tim");
    }

    @Test
    public void testNoAnnotation() {
        Spiffy spiffy = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        Something s = spiffy.findByIdNoAnnotation(7);
        Assertions.assertThat((String)s.getName()).isEqualTo("Tim");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind int var1);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findByIdNoAnnotation(int var1);
    }
}

