/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SqlObjectArgumentTest {
    private static final String INSERT_QUERY = "INSERT INTO something (id, integerValue)\n VALUES (:id, :status)";
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testInsertClass() {
        Handle h = this.h2Extension.getSharedHandle();
        StatusDao dao = (StatusDao)h.attach(StatusDao.class);
        int count = ((Update)((Update)h.createUpdate(INSERT_QUERY).bind("id", 11)).bind("status", (Argument)StatusClass.ONLINE)).execute();
        Assertions.assertThat((int)count).isOne();
        count = dao.insert(12, StatusClass.ONLINE.code);
        Assertions.assertThat((int)count).isOne();
        count = dao.insert(13, StatusClass.ONLINE);
        Assertions.assertThat((int)count).isOne();
        Query query = h.createQuery("SELECT integerValue FROM something WHERE id = 13");
        int code = (Integer)query.mapTo(Integer.TYPE).one();
        Assertions.assertThat((int)code).isEqualTo(StatusClass.ONLINE.code);
    }

    @Test
    public void testInsertEnum() {
        Handle h = this.h2Extension.getSharedHandle();
        StatusDao dao = (StatusDao)h.attach(StatusDao.class);
        int count = ((Update)((Update)h.createUpdate(INSERT_QUERY).bind("id", 21)).bind("status", (Argument)StatusEnum.ONLINE)).execute();
        Assertions.assertThat((int)count).isOne();
        count = dao.insert(22, StatusEnum.ONLINE.code);
        Assertions.assertThat((int)count).isOne();
        count = ((StatusDao)h.attach(StatusDao.class)).insert(23, StatusEnum.ONLINE);
        Assertions.assertThat((int)count).isOne();
        Query query = h.createQuery("SELECT integerValue FROM something WHERE id = 23");
        int code = (Integer)query.mapTo(Integer.TYPE).one();
        Assertions.assertThat((int)code).isEqualTo(StatusEnum.ONLINE.code);
    }

    public static interface StatusDao {
        @SqlUpdate(value="INSERT INTO something (id, integerValue)\n VALUES (:id, :status)")
        public int insert(int var1, int var2);

        @SqlUpdate(value="INSERT INTO something (id, integerValue)\n VALUES (:id, :status)")
        public int insert(int var1, StatusClass var2);

        @SqlUpdate(value="INSERT INTO something (id, integerValue)\n VALUES (:id, :status)")
        public int insert(int var1, StatusEnum var2);
    }

    public static class StatusClass
    implements Argument {
        public static final StatusClass ONLINE = new StatusClass(111);
        public static final StatusClass OFFLINE = new StatusClass(110);
        private final int code;

        private StatusClass(int code) {
            this.code = code;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setInt(position, this.code);
        }
    }

    public static enum StatusEnum implements Argument
    {
        ONLINE(121),
        OFFLINE(120);

        private final int code;

        private StatusEnum(int code) {
            this.code = code;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setInt(position, this.code);
        }
    }
}

