/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class MockClock
extends Clock {
    private ZonedDateTime now;

    private MockClock(ZonedDateTime now) {
        this.now = now;
    }

    @Override
    public ZoneId getZone() {
        return this.now.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new MockClock(this.now.withZoneSameInstant(zone));
    }

    @Override
    public Instant instant() {
        return this.now.toInstant().truncatedTo(ChronoUnit.MICROS);
    }

    public Instant advance(long amountToAdd, TemporalUnit unit) {
        this.now = this.now.plus(amountToAdd, unit);
        return this.instant();
    }

    public static MockClock now() {
        return MockClock.at(ZonedDateTime.now());
    }

    public static MockClock at(ZonedDateTime now) {
        return new MockClock(now);
    }
}

