/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.CaseStrategy;
import org.jdbi.v3.core.mapper.GenericMapMapperFactory;
import org.jdbi.v3.core.mapper.MapMappers;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class GenericMapMapperFactoryTest {
    private static final String QUERY = "select 1.0 as one, 2.0 as two, 3.0 as three";
    @RegisterExtension
    public JdbiExtension sqliteExtension = JdbiExtension.sqlite().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @BeforeEach
    public void before() {
        this.jdbi = (Jdbi)this.sqliteExtension.getJdbi().registerRowMapper((RowMapperFactory)new GenericMapMapperFactory());
    }

    @Test
    public void canFluentMapToGenericTypeOfMap() {
        this.jdbi.useHandle(h -> {
            Map map = (Map)h.createQuery(QUERY).mapTo((GenericType)new GenericType<Map<String, BigDecimal>>(){}).one();
            ((MapAssert)Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new String[]{"one", "two", "three"})).containsValues((Object[])new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0")});
        });
    }

    @Test
    public void canFluentMapToMapWithGenericTypeForValue() {
        this.jdbi.useHandle(h -> {
            Map map = (Map)h.createQuery(QUERY).mapToMap((GenericType)new GenericType<BigDecimal>(){}).one();
            ((MapAssert)Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new String[]{"one", "two", "three"})).containsValues((Object[])new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0")});
        });
    }

    @Test
    public void canFluentMapToMapWithClassForValue() {
        this.jdbi.useHandle(h -> {
            Map map = (Map)h.createQuery(QUERY).mapToMap(BigDecimal.class).one();
            ((MapAssert)Assertions.assertThat((Map)map).containsOnlyKeys((Object[])new String[]{"one", "two", "three"})).containsValues((Object[])new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0")});
        });
    }

    @Test
    public void canMapToMapWithSqlObject() {
        this.jdbi.useExtension(WithTypicalMap.class, withTypicalMap -> {
            List<Map<String, BigDecimal>> list = withTypicalMap.getMapList();
            Assertions.assertThat(list).hasSize(1);
            Map<String, BigDecimal> map = list.get(0);
            ((MapAssert)Assertions.assertThat(map).containsOnlyKeys((Object[])new String[]{"one", "two", "three"})).containsValues((Object[])new BigDecimal[]{new BigDecimal("1.0"), new BigDecimal("2.0"), new BigDecimal("3.0")});
        });
    }

    @Test
    public void mapToMapFailsOnUnmappableClass() {
        this.jdbi.useHandle(h -> {
            Query query = h.createQuery(QUERY);
            Assertions.assertThatThrownBy(() -> query.mapToMap(Alien.class)).hasMessage("no column mapper found for type " + String.valueOf(Alien.class));
        });
    }

    @Test
    public void mapToMapFailsOnUnmappableGenericType() {
        this.jdbi.useHandle(h -> {
            Query query = h.createQuery(QUERY);
            GenericType<Alien> type = new GenericType<Alien>(){};
            Assertions.assertThatThrownBy(() -> GenericMapMapperFactoryTest.lambda$mapToMapFailsOnUnmappableGenericType$6(query, (GenericType)type)).hasMessage("no column mapper found for type " + String.valueOf(type));
        });
    }

    @Test
    public void sqlObjectMethodFailsOnCallForUnmappableType() {
        this.jdbi.useExtension(WithUnsupportedMap.class, withUnsupportedMap -> Assertions.assertThatThrownBy(withUnsupportedMap::getMapList).hasMessage("No mapper registered for type java.util.Map<java.lang.String, " + Alien.class.getName() + ">"));
    }

    @Test
    public void duplicateColumnsWithoutCaseChangeCauseException() {
        this.jdbi.useHandle(h -> {
            ((MapMappers)h.getConfig(MapMappers.class)).setCaseChange((UnaryOperator)CaseStrategy.NOP);
            try (Query query = h.createQuery(QUERY.replace("two", "one"));){
                ResultIterable iterable = query.mapToMap(BigDecimal.class);
                Assertions.assertThatThrownBy(() -> ((ResultIterable)iterable).findOnly()).hasMessageContaining("map key \"one\" (from column \"one\") appears twice");
            }
        });
    }

    @Test
    public void duplicateKeysAfterCaseChangeCauseException() {
        this.jdbi.useHandle(h -> {
            ((MapMappers)h.getConfig(MapMappers.class)).setCaseChange((UnaryOperator)CaseStrategy.LOWER);
            try (Query query = h.createQuery(QUERY.replace("two", "ONE"));){
                ResultIterable iterable = query.mapToMap(BigDecimal.class);
                Assertions.assertThatThrownBy(() -> ((ResultIterable)iterable).findOnly()).hasMessageContaining("map key \"one\" (from column \"ONE\") appears twice");
            }
        });
    }

    private static /* synthetic */ void lambda$mapToMapFailsOnUnmappableGenericType$6(Query query, GenericType type) throws Throwable {
        query.mapToMap(type);
    }

    public static interface WithTypicalMap {
        @SqlQuery(value="select 1.0 as one, 2.0 as two, 3.0 as three")
        public List<Map<String, BigDecimal>> getMapList();
    }

    public static interface WithUnsupportedMap {
        @SqlQuery(value="select 1.0 as one, 2.0 as two, 3.0 as three")
        public List<Map<String, Alien>> getMapList();
    }

    public static class Alien {
    }
}

