/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class Article {

    public static Article newArticle(long id, String title) {
        return newArticle(id, title, null);
    }

    public static Article newArticle(long id, String title, String content, Comment... comments) {
        Article article = new Article(id, title, content);

        article.getComments().addAll(Arrays.asList(comments));

        return article;
    }

    private long id;
    private String title;
    private String content;
    private List<Comment> comments = new ArrayList<>();

    public Article() {}

    @JdbiConstructor
    public Article(long id, String title, String content) {
        setId(id);
        setTitle(title);
        setContent(content);
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<Comment> getComments() {
        return comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Article article = (Article) o;
        return id == article.id
                && Objects.equals(title, article.title)
                && Objects.equals(content, article.content)
                && Objects.equals(comments, article.comments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, title, content, comments);
    }

    @Override
    public String toString() {
        return "Article{"
                + "id=" + id
                + ", title='" + title + '\''
                + ", content='" + content + '\''
                + ", comments=" + comments
                + '}';
    }
}
