/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionConfigurer;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.config.UseSqlParser;

public class UseSqlParserImpl
implements ExtensionConfigurer {
    public void configureForMethod(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType, Method method) {
        UseSqlParser anno = (UseSqlParser)annotation;
        SqlParser parser = this.instantiate(anno.value(), sqlObjectType, method);
        ((SqlStatements)config.get(SqlStatements.class)).setSqlParser(parser);
    }

    public void configureForType(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        this.configureForMethod(config, annotation, sqlObjectType, null);
    }

    private SqlParser instantiate(Class<? extends SqlParser> parserClass, Class<?> sqlObjectType, @Nullable Method method) {
        return Stream.of(UseSqlParserImpl.tryConstructor(parserClass, new Object[0]), UseSqlParserImpl.tryConstructor(parserClass, sqlObjectType), UseSqlParserImpl.tryConstructor(parserClass, sqlObjectType, method)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unable to instantiate, no viable constructor for " + parserClass.getName()));
    }

    private static <T extends SqlParser> Supplier<T> tryConstructor(Class<T> clazz, Object ... args) {
        return Unchecked.supplier(() -> {
            try {
                Object[] nonNullArgs = Arrays.stream(args).filter(Objects::nonNull).toArray(Object[]::new);
                Class[] argClasses = (Class[])Arrays.stream(nonNullArgs).map(Object::getClass).toArray(Class[]::new);
                MethodType type = MethodType.methodType(Void.TYPE, argClasses);
                return (SqlParser)clazz.cast(MethodHandles.lookup().findConstructor(clazz, type).invokeWithArguments(nonNullArgs));
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
        });
    }
}

